% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/32_KFOLD_INDICES.R
\name{kfold.idx}
\alias{kfold.idx}
\title{Indices for K-fold validation}
\usage{
kfold.idx(target, k = 10, type, seed = 2191)
}
\arguments{
\item{target}{Binary target variable.}

\item{k}{Number of folds. If \code{k} is equal or greater than the number of observations of
target variable, then validation procedure is equivalent to leave one out cross-validation (LOOCV)
method. For stratified sampling, k is compared with frequencies of 0 and 1 from target.
Default is set to 10.}

\item{type}{Sampling type. Possible options are \code{"random"} and \code{"stratified"}.}

\item{seed}{Random seed needed for ensuring the result reproducibility. Default is 2191.}
}
\value{
The command \code{kfold.idx} returns a list of k folds estimation and validation indices.
}
\description{
\code{kfold.idx} provides indices for K-fold validation.
}
\examples{
suppressMessages(library(PDtoolkit))
data(loans)
#good-bad ratio
prop.table(table(loans$Creditability))
#random k-folds
kf.r <- kfold.idx(target = loans$Creditability, k = 5, type = "random", seed = 2191)
lapply(kf.r, function(x) prop.table(table(loans$Creditability[x[[2]]])))
#stratified k-folds
kf.s <- kfold.idx(target = loans$Creditability, k = 5, type = "stratified", seed = 2191)
lapply(kf.s, function(x) prop.table(table(loans$Creditability[x[[2]]])))
}
