% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peach.run.R
\name{peach}
\alias{peach}
\title{Pareto Enrichment Analysis for Combining Heterogeneous datasets}
\usage{
peach(
  input.data = NULL,
  nsample = 1000,
  input.pathway = NULL,
  direction = "up",
  is.Fisher.Stouffer = TRUE
)
}
\arguments{
\item{input.data}{The test statistics of each gene from multiple datasets (the test statistics is from the case versus control statistical test, e.g. t-test). The rows are genes where the rownames are gene names (official gene symbols). The columns are the individual datasets.}

\item{nsample}{The number of random sampling times for Pareto meta-analysis p-value calculation. As Pareto based meta-analysis is a non-parametric method, this parameter decides the NULL distribution size of meta-pathway p-value computing.}

\item{input.pathway}{the pathways or genesets in the format of lists. The pathways or genesets should be defined by official gene symbols. An example KEGG pathway can be obtained with data('KEGG'). (The pathway input format is the same with the output from the 'gmtPathways' function from fgsea package.)}

\item{direction}{"up" or "down" denoting if the pathway p-value is calculated by accounting for pathway up-regulation or down-regulation. The default is "up", which means the peach function calculated combined p-value indicates if a pathway is up-regulated across the datasets being combined.}

\item{is.Fisher.Stouffer}{Logical indication. If TRUE, peach function will output the combined meta-pathway-p-value from non-parametric Fisher's and Stouffer's method. The combined p-value will not be the same with the original Fisher's or Stouffer's method, as this version has the Monte Carlo implementation of these two methods that accounts for the correlation from the input dataset.}
}
\description{
This function is for pathway enrichment meta-analysis with Pareto dominance based method. The input of this function is the gene level test-statistics (e.g. t statistics) from multiple datasets on which meta analysis will be performed, and a pathway (or geneset) list. It outputs the pathway p-values for each individual dataset as well as the pareto combined pathway p-values in a data frame.
}
\examples{
## load example input data (TCGA cancer versus control test t statistics)
data('TCGA.input')
## load the KEGG pathways
data('KEGG')
## Run peach
\donttest{
res = peach(input.data=TCGA.input,input.pathway=KEGG,direction ="up",is.Fisher.Stouffer = TRUE)
}
}
\keyword{function}
\keyword{peach}
