% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Steps.R
\name{Steps}
\alias{Steps}
\title{Nested Resolvable Designs and associated Uniform Designs in different stages.}
\usage{
Steps(m, n, stage = "all")
}
\arguments{
\item{m}{Dimension of the projective geometry defined on GF(2).}

\item{n}{The sub-variety of the block to be deleted.}

\item{stage}{Stage of recurrence wanted (single value or vector) :
'all' Print all designs.
'S1' Print the configurations of BIB of first generation.
'S2' Print the configurations of BIB of seconde generation.
'S3' Print the configurations of RBIB.
'S4' Print the configurations of the uniform designs associate to each nested resolvable.}
}
\value{
A LIST, with the parametrs and the configurations on each stages of recurrence.
}
\description{
Gives the different stages of nested design begening from
a projective geometry, BIBD, BIBD seconde generation, RBIBD
and associated uniform designs.
}
\examples{
\dontrun{
list1<-Steps(4,1) #Get all stages : of the PG(4,2)

list2<-Steps(4,1,c('S1','S2')) #Get the 2 first stages : of the PG(4,2)

list3<-Steps(4,1,c('S1','S4')) #Get the first & the last stage : of the PG(4,2)

list4<-Steps(4,1,'S4') #Get the last stage : of the PG(4,2)
}
}
\author{
Mohamed Laib, Abla Boudraa and Zebida Gheribi-Aoulmi
}
\references{
Gheribi-Aoulmi. Z and M. Bousseboua Recursive methods for construction of balanced n-ary block designs. Serdica Math.J (31), 2005,189-200
}

