% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.genesys.R
\name{read.genesys}
\alias{read.genesys}
\title{Convert 'Darwin Core - Germplasm' zip archive to a flat file}
\usage{
read.genesys(zip.genesys, scrub.names.space = TRUE, readme = TRUE)
}
\arguments{
\item{zip.genesys}{A character vector giving the file path to the downloaded 
zip file from Genesys.}

\item{scrub.names.space}{logical. If \code{TRUE}, all space characters are 
removed from name field in names extension (see \strong{Details}).}

\item{readme}{logical. If \code{TRUE}, the genesys zip file readme is printed
to console.}
}
\value{
A data.frame with the flat file form of the genesys data.
}
\description{
\code{read.genesys} reads PGR data in a Darwin Core - germplasm zip 
archive downloaded from genesys database and creates a flat file
\code{data.frame} from it.
}
\details{
This function helps to import to R environment, the PGR data 
downloaded from genesys database \url{https://www.genesys-pgr.org/} as a 
Darwin Core - germplasm (DwC-germplasm) zip archive. The different csv files 
in the archive are merged as a flat file into a single \code{data.frame}.

All the space characters can be removed from the fields corresponding to 
accession names such as acceNumb, collNumb, ACCENAME, COLLNUMB, DONORNUMB and
OTHERNUMB using the argument \code{scrub.names.space} to facilitate creation 
of KWIC index with \code{\link[PGRdup]{KWIC}} function and subsequent
matching operations to identify probable duplicates with
\code{\link[PGRdup]{ProbDup}} function.

The argument \code{readme} can be used to print the readme file in the 
archive to console, if required.
}
\seealso{
\code{\link[data.table]{data.table}}
}
