% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParseProbDup.R
\name{ParseProbDup}
\alias{ParseProbDup}
\title{Parse an object of class \code{ProbDup} to a data frame.}
\usage{
ParseProbDup(pdup, max.count = 30, insert.blanks = TRUE)
}
\arguments{
\item{pdup}{An object of class \code{ProbDup}.}

\item{max.count}{The maximum count of probable duplicate sets which are to be parsed to a data frame.}

\item{insert.blanks}{logical. If \code{TRUE}, inserts a row of \code{NAs} 
after each set.}
}
\value{
A data frame of the long/narrow form of the probable duplicate sets 
  data with the following core columns: \tabular{ll}{ 
  \code{SET_NO} \tab The set number. \cr \code{TYPE} \tab The type of 
  probable duplicate set. 'F' for fuzzy, 'P' for phonetic and 'S' for 
  semantic matching sets. \cr \code{K} \tab The KWIC index or database of 
  origin of the record. The \code{method} is specified within the square 
  brackets in the column name.  \cr \code{PRIM_ID} \tab The primary ID of the
  accession record from which the set could be identified. \cr \code{IDKW} 
  \tab The 'matching' keywords along with the IDs. \cr \code{COUNT} \tab The number of elements in a set. \cr } For the 
  retrieved columns(fields) the prefix \code{K*} indicates the KWIC index of 
  origin.
}
\description{
\code{ParseProbDup} converts an object of class \code{ProbDup} to a data frame for export.
}
\examples{

\dontshow{
threads_dt <- data.table::getDTthreads()
threads_OMP <- Sys.getenv("OMP_THREAD_LIMIT")
data.table::setDTthreads(2)

data.table::setDTthreads(2)
Sys.setenv(`OMP_THREAD_LIMIT` = 2)
}

\dontrun{

#' # Load PGR passport database
GN <- GN1000

# Specify as a vector the database fields to be used
GNfields <- c("NationalID", "CollNo", "DonorID", "OtherID1", "OtherID2")

# Clean the data
GN[GNfields] <- lapply(GN[GNfields], function(x) DataClean(x))
y1 <- list(c("Gujarat", "Dwarf"), c("Castle", "Cary"), c("Small", "Japan"),
c("Big", "Japan"), c("Mani", "Blanco"), c("Uganda", "Erect"),
c("Mota", "Company"))
y2 <- c("Dark", "Light", "Small", "Improved", "Punjab", "SAM")
y3 <- c("Local", "Bold", "Cary", "Mutant", "Runner", "Giant", "No.",
        "Bunch", "Peanut")
GN[GNfields] <- lapply(GN[GNfields], function(x) MergeKW(x, y1, delim = c("space", "dash")))
GN[GNfields] <- lapply(GN[GNfields], function(x) MergePrefix(x, y2, delim = c("space", "dash")))
GN[GNfields] <- lapply(GN[GNfields], function(x) MergeSuffix(x, y3, delim = c("space", "dash")))

# Generate KWIC index
GNKWIC <- KWIC(GN, GNfields)

# Specify the exceptions as a vector
exep <- c("A", "B", "BIG", "BOLD", "BUNCH", "C", "COMPANY", "CULTURE", 
         "DARK", "E", "EARLY", "EC", "ERECT", "EXOTIC", "FLESH", "GROUNDNUT", 
         "GUTHUKAI", "IMPROVED", "K", "KUTHUKADAL", "KUTHUKAI", "LARGE", 
         "LIGHT", "LOCAL", "OF", "OVERO", "P", "PEANUT", "PURPLE", "R", 
         "RED", "RUNNER", "S1", "SAM", "SMALL", "SPANISH", "TAN", "TYPE", 
         "U", "VALENCIA", "VIRGINIA", "WHITE")
          
# Specify the synsets as a list
syn <- list(c("CHANDRA", "AH114"), c("TG1", "VIKRAM"))

# Fetch probable duplicate sets
GNdup <- ProbDup(kwic1 = GNKWIC, method = "a", excep = exep, fuzzy = TRUE,
                 phonetic = TRUE, encoding = "primary", 
                 semantic = TRUE, syn = syn)
                 
# Convert to data frame of sets               
GNdupParsed <- ParseProbDup(GNdup)

}

\dontshow{
data.table::setDTthreads(threads_dt)
Sys.setenv(`OMP_THREAD_LIMIT` = threads_OMP)
}

}
\seealso{
\code{\link[PGRdup]{ProbDup}},
}
