% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interp_extrap_helpers.R
\name{choose_interp_extrap_method}
\alias{choose_interp_extrap_method}
\title{Choose a method for calculation in the interval between concentrations}
\usage{
choose_interp_extrap_method(conc, time, interp_method, extrap_method, tmax)
}
\arguments{
\item{conc}{A vector of concentrations (\code{NA} values are not allowed)}

\item{time}{A vector of times (\code{NA} values are not allowed)}

\item{interp_method}{Method to use for interpolation between time points}

\item{extrap_method}{Method to use for extrapolation after the last time
point above (an AUC calculation method)}

\item{tmax}{Time of maximum concentration}
}
\value{
A character vector of extrapolation methods to use between each
  \code{conc} and after the last \code{conc}.  Values will be one or more of
  "linear" (use linear interpolation), "log" (use log interpolation), "zero"
  (the value is zero), and the last value may be "clastpred", "clastobs", or
  "zero" indicating extrapolation from tlast using lambda.z and clast,pred or
  clast,obs, or zero.
}
\description{
This function should be used for any interpolation/extrapolation function. It
will standardize the method of choosing which method to use for interpolation
and extrapolation.
}
\examples{
PKNCA:::choose_interp_extrap_method(
  conc=c(1, 2, 4, 2, 1, 0, 0),
  time=0:6,
  interp_method="lin up/log down",
  extrap_method="aucinf.obs"
)
}
\keyword{Internal}
