% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseFormula.R
\name{parseFormula}
\alias{parseFormula}
\title{Parse a formula into its component parts.}
\usage{
parseFormula(form, require.groups = FALSE, require.two.sided = FALSE)
}
\arguments{
\item{form}{the formula to extract into its parts}

\item{require.groups}{is it an error not to have groups?}

\item{require.two.sided}{is it an error to have a one-sided
formula?}
}
\value{
A parseFormula class list with elements of
\describe{
  \item{model}{The left~right side of the model (excluding groups)}
  \item{lhs}{The call for the left hand side}
  \item{rhs}{The call for the right hand side (excluding groups)}
  \item{groups}{The call for the groups}
  \item{groupFormula}{A formula form of the groups}
  \item{env}{The original formula's environment}
}
}
\description{
This function supports parsing
}
\details{
This function extracts the left hand side (\code{lhs}), right hand
side (\code{rhs}), groups (\code{groups} and as a formula,
\code{grpFormula}), the environment (\code{env}, and the original
left/right hand side of the model (\code{model}).

This function borrows heavily from the \code{parseGroupFormula}
function in the doBy package.
}
\examples{
parseFormula("a~b", require.groups=FALSE)
## parseFormula("a~b", require.groups=TRUE) # This is an error
parseFormula("a~b|c")
parseFormula("a~b|c")$groups
}

