% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_calc.R
\name{time_calc}
\alias{time_calc}
\title{Times relative to an event (typically dosing)}
\usage{
time_calc(time_event, time_obs, units = NULL)
}
\arguments{
\item{time_event}{A vector of times for events}

\item{time_obs}{A vector of times for observations}

\item{units}{Passed to `base::as.numeric.difftime()`}
}
\value{
A data.frame with columns for:
\itemize{
  \item{event_number_before}{The index of `time_event` that is the last one before `time_obs` or `NA` if none are before.}
  \item{event_number_after}{The index of `time_event` that is the first one after `time_obs` or `NA` if none are after.}
  \item{time_before}{The minimum time that the current `time_obs` is before a `time_event`, 0 if at least one `time_obs == time_event`.}
  \item{time_after}{The minimum time that the current `time_obs` is after a `time_event`, 0 if at least one `time_obs == time_event`.}
  \item{time_after_first}{The time after the first event (may be negative or positive).}
}

`time_after` and `time_before` are calculated if they are at the same time as
a dose, they equal zero, and otherwise, they are calculated relative to the
dose number in the `event_number_*` columns.
}
\description{
Times relative to an event (typically dosing)
}
