% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{ppcheckPLMIX_cond}
\alias{ppcheckPLMIX_cond}
\title{Conditional posterior predictive check for mixtures of Plackett-Luce models}
\usage{
ppcheckPLMIX_cond(pi_inv, seq_G, MCMCsampleP, MCMCsampleW,
  MAPestP = vector(mode = "list", length = length(seq_G)),
  MAPestW = vector(mode = "list", length = length(seq_G)),
  label_switching_adj = FALSE, top1 = TRUE, paired = TRUE,
  adj_post_sample = FALSE, parallel = FALSE)
}
\arguments{
\item{pi_inv}{Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of partial orderings.}

\item{seq_G}{Numeric vector with the number of components of the considered Plackett-Luce mixtures.}

\item{MCMCsampleP}{List of length \code{length(seq_G)}, whose generic element is a numeric \eqn{L}\eqn{\times}{x}\eqn{(G*K)} matrix with the posterior MCMC samples of the component-specific support parameters.}

\item{MCMCsampleW}{List of length \code{length(seq_G)}, whose generic element is a numeric \eqn{L}\eqn{\times}{x}\eqn{G} matrix with the posterior MCMC samples of the mixture weights.}

\item{MAPestP}{List of length \code{length(seq_G)}, whose generic element is a numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix with the MAP estimates of the component-specific support parameters. If \code{label_switching_adj} argument is \code{TRUE}, this argument is necessary to be used as pivot in the Pivotal Relabeling Algorithm.}

\item{MAPestW}{List of length \code{length(seq_G)}, whose generic element is a numeric vector of \eqn{G} MAP estimates of the mixture weights. If \code{label_switching_adj} argument is \code{TRUE}, this argument is necessary to be used as pivot in the Pivotal Relabeling Algorithm.}

\item{label_switching_adj}{Logical: whether MCMC samples have to be processed to remove the label switching phenomenon. See Details for further explanation. Default is \code{FALSE}.}

\item{top1}{Logical: whether the posterior predictive \eqn{p}-value based on top item frequencies has to be computed. Default is \code{TRUE}.}

\item{paired}{Logical: whether the posterior predictive \eqn{p}-value based on paired comparison frequencies has to be computed. Default is \code{TRUE}.}

\item{adj_post_sample}{Logical: whether MCMC samples adjusted for label switching have to be returned in the output. Default is \code{FALSE}.}

\item{parallel}{Logical: whether parallelization should be used. Default is \code{FALSE}.}
}
\value{
A list of named objects:

 \item{\code{post_pred_pvalue_cond}}{ Numeric \code{length(seq_G)}\eqn{\times}{x}\eqn{2} matrix of posterior predictive \eqn{p}-values based on top item and paired comparison frequencies. If \code{top1} and/or \code{paired} argument is \code{FALSE}, corresponding matrix entries are \code{NA}.}
 \item{\code{final_sampleP}}{ List of length \code{length(seq_G)}, whose generic element is a numeric \eqn{G}\eqn{\times}{x}\eqn{K}\eqn{\times}{x}\eqn{L} array with the MCMC samples of the component-specific support parameters adjusted for label switching. If \code{adj_post_sample} argument is \code{FALSE}, list elements are \code{NULL}.}
 \item{\code{final_sampleW}}{ List of length \code{length(seq_G)}, whose generic element is a numeric \eqn{L}\eqn{\times}{x}\eqn{G} matrix with the MCMC samples of the mixture weights adjusted for label switching. If \code{adj_post_sample} argument is \code{FALSE}, list elements are \code{NULL}.}
}
\description{
Perform conditional posterior predictive check to assess the goodness-of-fit of Bayesian mixtures of Plackett-Luce models with a different number of components. See Details for further explanation.
}
\details{
The \code{ppcheckPLMIX_cond} function returns two posterior predictive \eqn{p}-values based on chi squared discrepancy variables involving, respectively,: (i) top item frequencies and (ii) paired comparison frequencies. In the presence of partial sequences in the input \code{pi_inv}, the same missingness patterns of the observed dataset (i.e., the number of items ranked by each sample unit) are reproduced on the replicated datasets from the posterior predictive distribution.

The \code{ppcheckPLMIX_cond} function also performs the label switching adjustment of the posterior MCMC samples via Pivotal Relabeling Algorithm, by employing the \code{\link[label.switching]{pra}} function of the \code{\link[label.switching]{label.switching}} package.
}
\examples{
library(PLMIX)
data(d_carconf)
K <- ncol(d_carconf)
mcmc_iterations=30
burnin=10
outputGIBBS_1 <- gibbsPLMIX(pi_inv=d_carconf, K=K, G=1, n_iter=mcmc_iterations, 
                            n_burn=burnin)
outputGIBBS_2 <- gibbsPLMIX(pi_inv=d_carconf, K=K, G=2, n_iter=mcmc_iterations,
                            n_burn=burnin)
outputCHECKCOND <- ppcheckPLMIX_cond(pi_inv=d_carconf, seq_G=1:2, 
                                     MCMCsampleP=list(outputGIBBS_1$P, outputGIBBS_2$P), 
                                     MCMCsampleW=list(outputGIBBS_1$W, outputGIBBS_2$W))
outputCHECKCOND$post_pred_pvalue
}
\author{
Cristina Mollica and Luca Tardella
}
\references{
Mollica, C., Tardella, L. (2016). Bayesian Plackett-Luce mixture models for partially ranked data. \emph{Psychometrika} (published online), DOI: 10.1007/s11336-016-9530-0.
}

