% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsim.pTest.r
\name{plsim.pTest}
\alias{plsim.pTest}
\title{Testing Parametric Components}
\usage{
plsim.pTest(
  fit,
  significant_level = 0.05,
  parameterSelected = NULL,
  TargetMethod = "plsimest"
)
}
\arguments{
\item{fit}{the result of function \link{plsim.est} or \link{plsim.vs.soft}.}

\item{significant_level}{significant level for the test, default: 0.05.}

\item{parameterSelected}{select some coefficients for testing, default: NULL.}

\item{TargetMethod}{default: "plsim.est".}
}
\value{
\item{T1}{test statistic.}
\item{pvalue}{p-value.}
\item{m}{degree of freedom of Chi-squared distribution.}
\item{delta}{ \eqn{delta=1} means to reject the hypothesis \eqn{H_0}, while \eqn{delta=0} means to accept the hypothesis \eqn{H_0}. }
}
\description{
Test whether some elements of \eqn{\alpha} and \eqn{\beta} are zero, that is,
\deqn{H_0: \alpha_{i_1}=\cdots=\alpha_{i_k}=0 \ \mbox{ and } \beta_{j_1}=\cdots=\beta_{j_l}=0}
versus
\deqn{H_1: \mbox{not \ all }\ \alpha_{i_1},\cdots,\alpha_{i_k}  \ \mbox{ and } \beta_{j_1}, \cdots,\beta_{j_l} \ \mbox{ are equal to }\ 0.}
}
\examples{

n = 50
sigma = 0.1

alpha = matrix(1,2,1)
alpha = alpha/norm(alpha,"2")

beta = matrix(4,1,1)

x = matrix(1,n,1)
z = matrix(runif(n*2),n,2)
y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

# Obtain parameters in PLSiM using Profile Least Squares Estimator
fit_plsimest = plsim.est(x, z, y)

# Test whether the parameters of parametric part estimated by plsimest
# are zero
res_pTest_plsimest = plsim.pTest(fit_plsimest)

# Test whether the second parameter of parametric part estimated by plsimest
# is zero
res_pTest_plsimest_ = plsim.pTest(fit_plsimest,parameterSelected = c(2))

# Obtain parameters in PLSiM using Penalized Profile Least Squares Estimator
# with lambda set as 0.01
fit_plsim = plsim.vs.soft(x,z,y,lambda = 0.01)

# Test whether the parameters of parametric part estimated by plsim are zero
res_pTest_plsim = plsim.pTest(fit_plsim,TargetMethod = "plsim")

# Test whether the second parameter of parametric part estimated by plsim is zero
res_pTest_plsim_ = plsim.pTest(fit_plsim,parameterSelected = c(2),TargetMethod = "plsim")

}
\references{
H. Liang, X. Liu, R. Li, C. L. Tsai. \emph{Estimation and testing for partially linear single-index models}.
Annals of statistics, 2010, 38(6): 3811.
}
