% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spearmanTest.R
\name{spearmanTest}
\alias{spearmanTest}
\alias{spearmanTest.default}
\alias{spearmanTest.formula}
\title{Testing against Ordered Alternatives (Spearman Test)}
\usage{
spearmanTest(x, ...)

\method{spearmanTest}{default}(x, g, alternative = c("two.sided", "greater", "less"), ...)

\method{spearmanTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("two.sided", "greater", "less"),
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{"two.sided"}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{the estimated quantile of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{parameter}{the parameters of the test statistic, if any.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs a Spearman type test for testing against ordered alternatives.
}
\details{
A one factorial design for dose finding comprises an ordered factor,
.e. treatment with increasing treatment levels.
The basic idea is to correlate the ranks \eqn{R_{ij}} with the increasing
order number \eqn{1 \le i \le k} of the treatment levels (Kloke and McKean 2015).
More precisely, \eqn{R_{ij}} is correlated with the expected mid-value ranks
under the assumption of strictly increasing median responses.
Let the expected mid-value rank of the first group denote \eqn{E_1 = \left(n_1 + 1\right)/2}.
The following expected mid-value ranks are
\eqn{E_j = n_{j-1} + \left(n_j + 1 \right)/2} for \eqn{2 \le j \le k}.
The corresponding number of tied values for the \eqn{i}th group is \eqn{n_i}. #
The sum of squared residuals is
\eqn{D^2 = \sum_{i=1}^k \sum_{j=1}^{n_i} \left(R_{ij} - E_i \right)^2}.
Consequently, Spearman's rank correlation coefficient can be calculated as:

\deqn{
r_\mathrm{S} = \frac{6  D^2}
   {\left(N^3 - N\right)- C},
}{%
 SEE PDF
}

with
\deqn{
C = 1/2 - \sum_{c=1}^r \left(t_c^3 - t_c\right) +
1/2 - \sum_{i=1}^k \left(n_i^3 - n_i \right)
}{%
 SEE PDF
}
and \eqn{t_c} the number of ties of the \eqn{c}th group of ties.
Spearman's rank correlation coefficient can be tested for
significance with a \eqn{t}-test.
For a one-tailed test the null hypothesis of \eqn{r_\mathrm{S} \le 0}
is rejected and the alternative \eqn{r_\mathrm{S} > 0} is accepted if

\deqn{
r_\mathrm{S} \sqrt{\frac{\left(n-2\right)}{\left(1 - r_\mathrm{S}\right)}} > t_{v,1-\alpha},
}{%
 SEE PDF
}

with \eqn{v = n - 2} degree of freedom.
}
\note{
Factor labels for \code{g} must be assigned in such a way,
that they can be increasingly ordered from zero-dose
control to the highest dose level, e.g. integers {0, 1, 2, ..., k} or
letters {a, b, c, ...}. Otherwise the function may not
select the correct values for intended zero-dose control.

It is safer, to i) label the factor levels as given above,
and to ii) sort the data according to increasing dose-levels
prior to call the function (see \code{\link{order}}, \code{\link{factor}}).
}
\examples{
## Example from Sachs (1997, p. 402)
x <- c(106, 114, 116, 127, 145,
       110, 125, 143, 148, 151,
       136, 139, 149, 160, 174)
g <- gl(3,5)
levels(g) <- c("A", "B", "C")

## Chacko's test
chackoTest(x, g)

## Cuzick's test
cuzickTest(x, g)

## Johnson-Mehrotra test
johnsonTest(x, g)

## Jonckheere-Terpstra test
jonckheereTest(x, g)

## Le's test
leTest(x, g)

## Spearman type test
spearmanTest(x, g)

## Murakami's BWS trend test
bwsTrendTest(x, g)

## Fligner-Wolfe test
flignerWolfeTest(x, g)

## Shan-Young-Kang test
shanTest(x, g)

}
\references{
Kloke, J., McKean, J. W. (2015) \emph{Nonparametric statistical methods using R}.
Boca Raton, FL: Chapman & Hall/CRC.
}
\seealso{
\code{\link{kruskalTest}} and \code{\link{shirleyWilliamsTest}}
of the package \pkg{PMCMRplus},
\code{\link[stats]{kruskal.test}} of the library \pkg{stats}.
}
\concept{trendtest}
\keyword{htest}
\keyword{nonparametric}
