% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeSingleLab.R
\name{analyzeSingleLab}
\alias{analyzeSingleLab}
\title{Analyze Single Lab Qualitative PCR Outcomes}
\usage{
analyzeSingleLab(x = NULL, X = NULL, S = NULL, N = NULL,
  qLOD = 95, b = 1)
}
\arguments{
\item{x}{A matrix or dataframe with columns 'X', 'S' and 'N'.}

\item{X}{Nominal DNA concentration.}

\item{S}{Number of successfull PCR outcomes.}

\item{N}{Total number of PCR experiments.}

\item{qLOD}{The quantile(s) for the Limit Of Detection (LOD). Divided by \eqn{100} if greater than one.}

\item{b}{Fixed value for the corrective parameter}
}
\value{
A list with following items
\describe{
\item{x}{Input data plus extra columns}
\item{b}{The parameter \eqn{b}, as provided by the user}
\item{fit.glm.simple}{Results for the simplified GLM}
\item{fit.glm.full}{Results for the full GLM}
}
where "fit.glm.simple" and "fit.glm.full" are lists with the following parameters
 \describe{
  \item{b}{The parameter \eqn{b} (estimated from the model)}
  \item{lambda}{The parameter \eqn{\lambda} (estimated from the model)}
  \item{model}{The generalized linear model (GLM) fit to the data}
  \item{lod}{A named vector of LOD values}
  \item{lodci}{The 95\% confidence interval of the LOD}
  \item{warn}{A character vector containing warnings that appeared during GLM fit}
 }
}
\description{
Compute the POD curve and the LOD value to validate a qualitative PCR method of a single laboratory.
}
\details{
According to the suggestion of Uhlig et al. (2015), the corrective parameter \eqn{b} is set to \eqn{1} if it is close to \eqn{1} (simplified fit). However, if sensitivity is better than achievable according to the theoretical POD curve or average amplification probability is higher at higher dilution levels than at lower dilution levels, the \eqn{b} is estimated from the data (full fit). 
The value of \eqn{b} can be changed by the user. However, it is not recommended to do so.
}
\examples{
x <- cbind(
 X=c(0.1,1,2,5,10,20),
 S=c( 0,5,6,6,6,6 ),
 N=c( 6,6,6,6,6,6 )
)
obj <- analyzeSingleLab(x=x)
}
\references{
Uhlig et al. Accred Qual Assur (2015) 20: 75. https://doi.org/10.1007/s00769-015-1112-9
}
