% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdemog.R
\name{PlotMMig}
\alias{PlotMMig}
\title{Plot Multiple Migrations}
\usage{
PlotMMig(demograph_out, mig_par, m.adjust = 0)
}
\arguments{
\item{demograph_out}{A list of all demographic information. See the return value description of \code{\link{PlotMS}}.}

\item{mig_par}{A list of all settings for plotting the demographic graph. See the return value description of \code{\link{PlotMS}}.}

\item{m.adjust}{Migration threshold for plotting migration events. Migration events with strength higher than \code{m.adjust} will be shown. The migration strength is defined as the proportion of the target population being replaced by the source population per generation. Default value is 0.}
}
\description{
This function is used to plot all the migration events  based on the output of \code{PlotMS} with \code{plot.out} = FALSE and \code{demo.out} = TRUE. Plot settings should be customized  in \code{\link{PlotMS}}. Use function \code{\link{PlotMig}} to customize the plot of single migration.
}
\examples{
mig.cmd <- "./ms 15 100 -t 3.0 -I 6 0 7 0 0 8 0 -m 1 2 2.5 -m 2 1 2.5 -m 2 3 2.5 
-m 3 2 2.5 -m 4 5 2.5 -m 5 4 2.5 -m 5 6 2.5 -m 6 5 2.5 -em 2.0 3 4 2.5 
-em 2.0 4 3 2.5"
out<-PlotMS(input.cmd = mig.cmd, type = "ms", N4 = 10000, 
plot.out = FALSE, demo.out = TRUE, col.pop = 1:6, cex.lab = 1.5);
PlotMMig(demograph_out = out$demograph_out, mig_par = out$mig_par)
}
\seealso{
\code{\link{PlotMS}}
}
