% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsimpriorppt.R
\name{dsimpriorppt}
\alias{dsimpriorppt}
\title{Prior projected Polya tree distribution}
\usage{
dsimpriorppt(nsim = 5, mm = 4,mu = c(0, 0),
sig = 1, ll = 100, aa = 1, delta = 1.1, units = "radians")
}
\arguments{
\item{nsim}{integer indicating the number of simulations.}

\item{mm}{integer indicating the number of finite levels of the Polya tree.}

\item{mu}{mean vector of the projected bivariate normal distribution.}

\item{sig}{standard deviation of the projected bivariate normal distribution. We advise to always use sig = 1.}

\item{ll}{number of equally spaced points at which the projected distribution will be evaluated.}

\item{aa}{alpha. Precision parameter of the  Polya tree.}

\item{delta}{controls of the speed at which the variances of the branching probabilities move down in the tree,  rho(m)=m^delta.}

\item{units}{units of the support: "radians", "degrees" or "hours".}
}
\value{
An object with class priorppt.circ whose underlying structure is a list containing the following components:
\item{x}{points where the density is evaluated.}
\item{ppt.sims}{simulated density paths of the prior projected Polya tree.}
\item{stats}{descriptive statistics: mean direction and concentration of each simulated density.}
}
\description{
Simulates paths of prior projected Polya tree distributions centered
around a projected normal distribution.
}
\examples{
z <- dsimpriorppt(mu = c(5,5), nsim = 5, units = "radians")
priorppt.plot(z, plot.type = "line")
summary(z$stats)

}
\references{
Nieto-Barajas, L.E. & Nunez-Antonio, G. (2019). Projected Polya tree. https://arxiv.org/pdf/1902.06020.pdf
}
\seealso{
\code{\link[PPTcirc]{priorppt.plot}}, \code{\link[PPTcirc]{priorppt.summary}}
}
