% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapPPdecision.R
\name{decisionplot}
\alias{decisionplot}
\title{Decision plot}
\usage{
decisionplot(
  PPTreeregOBJ,
  testObs,
  final.rule = 5,
  method = "simple",
  varImp = "shapImp",
  final.leaf = NULL,
  Yrange = FALSE
)
}
\arguments{
\item{PPTreeregOBJ}{PPTreereg class object - a model to be explained}

\item{testObs}{test data observation}

\item{final.rule}{final rule to assign numerical values in the final nodes.
1: mean value in the final nodes
2: median value in the final nodes
3: using optimal projection
4: using all independent variables
5: using several significant independent variables}

\item{method}{simple or empirical method to calculate \code{PPKernelSHAP}}

\item{varImp}{\code{shapImp} or \code{treeImp} - Sorted by descending order of variance or the variable importance from coefficient values of the nodes inside
the \code{PPTreereg}.}

\item{final.leaf}{location of final leaf}

\item{Yrange}{show the entire final prediction range of the dependent variable. Default value is FALSE.}
}
\value{
An object of the class \code{ggplot}
}
\description{
decision plot for \code{PPKernelSHAP}
}
\details{
Decision plots are mainly used to explain individual predictions that how the model makes decision,
by focusing more on how model’s  predictions reach to their expected y value with \code{PPKernelSHAP} values.
}
\examples{
data(dataXY)
testX <- dataXY[1,-1]
Model <- PPTreereg(Y~., data = dataXY, DEPTH = 2)
decisionplot(Model, testX, final.rule =5, method="simple")

}
