% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictPPTreereg.R
\name{predict.PPTreereg}
\alias{predict.PPTreereg}
\alias{predict}
\title{predict \code{PPTreereg}}
\usage{
\method{predict}{PPTreereg}(
  object,
  newdata = NULL,
  Rule = 1,
  final.rule = 1,
  classinfo = FALSE,
  ...
)
}
\arguments{
\item{object}{a fitted object of class inheriting from \code{PPTreereg}}

\item{newdata}{the test data set}

\item{Rule}{split rule
1: mean of two group means
2: weighted mean of two group means - weight with group size
3: weighted mean of two group means - weight with group sd
4: weighted mean of two group means - weight with group se
5: mean of two group medians
6: weighted mean of two group medians - weight with group size
7: weighted mean of two group median - weight with group IQR
8: weighted mean of two group median - weight with group IQR
                                       and group size
9: cutoff that minimize error rates in each node}

\item{final.rule}{final rule to assign numerical values in the final nodes.
1: mean value in the final nodes
2: median value in the final nodes
3: using optimal projection
4: using all independent variables
5: using several significant independent variables}

\item{classinfo}{return final node information. Default value is FALSE}

\item{...}{arguments to be passed to methods}
}
\value{
Numeric
}
\description{
predict projection pursuit regression tree
}
\details{
Predict class for the test set with the fitted projection pursuit regression tree and
calculate prediction error.
}
\examples{
data(dataXY)
Model <- PPTreereg(Y~., data = dataXY, DEPTH = 2)
predict(Model)

}
\keyword{tree}
