% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evm.R
\name{cpi}
\alias{cpi}
\title{Cost Performance Index (CPI).}
\usage{
cpi(ev, ac)
}
\arguments{
\item{ev}{Earned Value.}

\item{ac}{Actual Cost.}
}
\value{
The function returns the Cost Performance Index (CPI) of work completed.
}
\description{
Cost Performance Index (CPI).
}
\examples{
bac <- 100000
actual_per_complete <- 0.35
ev <- ev(bac, actual_per_complete)
actual_costs <- c(9000, 18000, 36000, 70000, 100000)
time_period <- 3
ac <- ac(actual_costs, time_period)

cpi <- cpi(ev, ac)
cat("Cost Performance Index (CPI):", cpi, "\n")
}
