% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sel_resist.R
\name{sel_resist}
\alias{sel_resist}
\title{Calculating resistance values}
\usage{
sel_resist(Rmx, epis, dom)
}
\arguments{
\item{Rmx}{maximum resistance value, if all gene loci under consideration are homozygous resistant. \eqn{\code{numeric}, \ge 1}.}

\item{epis}{epistasis value, describing the interaction between resistance alleles. \code{numeric}. \code{epis} = 0: no interaction i.e. additive effects of resistance alleles, \code{epis} < 0: effect of resistance alleles is smaller than additive, \code{epis} > 0: effect of resistance alleles is higher than additive.}

\item{dom}{dominance of resistance alleles. \code{numeric vector} with length of \code{n_loci} (number of genes) and elements in [0,1].}
}
\value{
\code{numeric vector} with resistance values
}
\description{
Calculates the phenotypic resistance value (Renton et al. 2011) for each genotype in \code{dfgenotype}.
}
\details{
This function is used in \code{struc_preparation} to calculate the resistance value using the following term:
\deqn{  1 + (Rmx - 1) * (sum(dom)/n\_loci)^{2^{epis}}). }
Resistance values range from 1 to Rmx. The higher the resistance value is, the less the plant is susceptible to the herbicide.
\code{sel_resist} is only used by \code{\link{struc_preparation}}.
}
\examples{
#dfgenotype is usually generated by the function 'struc_preparation'.
#Here, a simple example is done by hand.
var1 <- c("00","01","02","10","11","12","20","21","21")
var2 <- c(0,0,0,1,1,1,2,2,2)
var3 <- c(0,1,2,0,1,2,0,1,2)
dfgenotype <- data.frame(genotype=var1,l1=var2,l2=var3)
sel_resist(Rmx=10, epis=0, dom=1)
}
\references{
Renton, M.; Diggle, A.; Manalil, S. & Powles, S. (2011): Does cutting herbicide rates threaten the sustainability of weed management in cropping systems? Journal of Theoretical Biology, 283, 14-27.
}
\seealso{
\code{\link{sel_herb}} \code{\link{intern_herbicide}}
}
