% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struc_preparation.R
\name{struc_preparation}
\alias{struc_preparation}
\title{Generating data input and output structures}
\usage{
struc_preparation(Rmx, n_loci, epis, dom)
}
\arguments{
\item{Rmx}{maximum resistance value, if all gene loci under consideration are homozygous resistant. \eqn{\code{numeric}, \ge 1}.}

\item{n_loci}{number of loci under consideration. \code{integer}, \eqn{0 \le n\_loci \le 4}.}

\item{epis}{epistasis value, describing the interaction between resistance alleles. \code{numeric}. \code{epis} = 0: no interaction i.e. additive effects of resistance alleles, \code{epis} < 0: effect of resistance alleles is smaller than additive, \code{epis} > 0: effect of resistance alleles is higher than additive.}

\item{dom}{dominance of resistance alleles. \code{numeric vector} with length of \code{n_loci} (number of genes) and elements in [0,1].}
}
\value{
Returns a \code{list} of two \code{data.frame} and a \code{table}:
\enumerate{
  \item mf: all possible combinations of parental genotypes (see 'dfgenotype$genotype') are saved in one column 'mf' (male, female). The column 'mf' is a character vector. Each string of the vector has twice the length of the number of resistance loci under consideration.
  \item dfgenotype: the structure to save the results of one simulation cycle (year). After each cycle the data is reset to the new start values. The first column 'genotype' is a character vector. Each string of the vector has the length of the number of resistance loci under consideration. Each locus can have 0, 1 or 2 resistance alleles. The second column 'resist' saves resistance values that are calculated according to the equation in the section 'details'.
  \item xprobab: the probabilities of occurrence for all possible genotypes in the offspring (F-generation) with all possible parent genotypes (P-generation). Free recombination is assumed. Column names are the combinations of parental genes, row names are genotypes of the offspring.
}
}
\description{
\code{struc_preparation} creates the data input and output structures (data.frames and table) for the simulation run, 'dfgenotype', 'xprobab' and 'mf'.
}
\details{
Prior to the simulation, a data.frame is generated to save results (\code{dfgenotype}). Additionally, a table with recombination probabilities (\code{xprobab}) is calculated. During the simulation run, probability values are not computed again but looked up in the table. PROSPER assumes diploid plants and maximum four resistance genes. To calculate the phenotypic resistance value for each genotype \code{\link{sel_resist}} is called.
}
\section{Warning}{

The run of \code{struc_preparation} is time consuming. Duration strongly increases with the number of genes under consideration, \code{n_loci}.
}

\examples{
#generate the genotype and probability tables for a simulation with two resistance 
#loci with one dominant and one partial dominant resistant allele, no epistasis, and a 
#maximumx resistance value of 10. 
ls()
struc_preparation(Rmx=10, n_loci=2, epis=0, dom=c(1,0.3))
ls()
rm(dfgenotype, mf, xprobab)
}
\seealso{
\code{\link{sel_resist}} \code{\link{gen_freq}}
}
