% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_misc.R
\name{shortenStrings}
\alias{shortenStrings}
\title{Shorten a string to a maximum length and indicate shorting by appending '..'}
\usage{
shortenStrings(x, max_len = 20, verbose = TRUE, allow_duplicates = FALSE)
}
\arguments{
\item{x}{Vector of input strings}

\item{max_len}{Maximum length allowed}

\item{verbose}{Print which strings were shortened}

\item{allow_duplicates}{If shortened strings are not discernible any longer, consider the short version valid (not the default), otherwise (default) return the full string (--> no-op)}
}
\value{
A vector of shortened strings
}
\description{
Some axis labels are sometimes just too long and printing them will either
squeeze the actual plot (ggplot) or make the labels disappear beyond the margins (graphics::plot)
One ad-hoc way of avoiding this is to shorten the names, hoping they are still meaningful to the viewer.
}
\details{
This function should be applied AFTER you tried more gentle methods, such as \code{\link{delLCP}} or \code{\link{simplifyNames}}.
}
\examples{
r = shortenStrings(c("gamg_101", "gamg_101230100451", "jurkat_06_100731121305", "jurkat_06_1"))
all(r == c("gamg_101", "gamg_101230100..", "jurkat_06_1007..", "jurkat_06_1"))

}
\seealso{
\code{\link{delLCP}}, \code{\link{simplifyNames}}
}

