% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_qualities.R
\name{qualCentered}
\alias{qualCentered}
\title{Quality metric for 'centeredness' of a distribution around zero.}
\usage{
qualCentered(x)
}
\arguments{
\item{x}{Numeric values (e.g. ppm errors)}
}
\value{
Value between [0, 1]
}
\description{
Ranges between 0 (worst score) and 1 (best score).
A median of zero gives the best score of 1.
The closer the median is to the most extreme value of the distribution, the smaller the score (until reaching 0).
Can be used for calibrated mass errors, as a measure of how well they are centered around 0.
E.g. if the median is 0.1, while the range is [-0.5,0.5], the score will be 0.8 (punishing the 20% deviation).
If the range of data is asymmetric, e.g. [-1.5,-0.5] and does not include zero, the score cannot reach 1, 
since the median can never be zero.
}

