% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designs_and_models.R
\name{calc_SE}
\alias{calc_SE}
\title{Computes Q_m, the standard error of the effect size estimate}
\usage{
calc_SE(
  d_m,
  J,
  K,
  nbar,
  Tbar,
  R2.1,
  R2.2,
  R2.3,
  ICC.2,
  ICC.3,
  omega.2,
  omega.3
)
}
\arguments{
\item{d_m}{a single RCT d_m (see list/naming convention).}

\item{J}{scalar; the number of schools}

\item{K}{scalar; the number of districts}

\item{nbar}{scalar; the harmonic mean of the number of units per school}

\item{Tbar}{scalar; the proportion of samples that are assigned to the
treatment}

\item{R2.1}{scalar, or vector of length M; percent of variation explained by
Level 1 covariates for each outcome}

\item{R2.2}{scalar, or vector of length M; percent of variation explained by
Level 2 covariates for each outcome}

\item{R2.3}{scalar, or vector of length M; percent of variation explained by
Level 3 covariates for each outcome}

\item{ICC.2}{scalar, or vector of length M; school intraclass correlation}

\item{ICC.3}{scalar, or vector of length M; district intraclass correlation}

\item{omega.2}{scalar, or vector of length M; ratio of school effect size
variability to random effects variability}

\item{omega.3}{scalar, or vector of length M; ratio of district effect size
variability to random effects variability}
}
\value{
vector; the standard error of the effect size estimate
}
\description{
Function to calculate the theoretical true (unadjusted) standard 
error of the ATE estimate for a given d_m and model, in effect size units.
}
\keyword{internal}
