% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kiselevlanalysis.R
\name{kiselevanalysis}
\alias{kiselevanalysis}
\title{Kiselev Isotherm Non linear Analysis}
\usage{
kiselevanalysis(theta, Ce)
}
\arguments{
\item{theta}{the numerical value for surface coverage}

\item{Ce}{the numerical value for equilibrium capacity}
}
\value{
the linear regression and the parameters for the Kiselev isotherm analysis
}
\description{
It is also known as localized monomolecular layer model and is only valid for surface coverage theta > 0.68.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
kiselevanalysis(Ce, Qe)
}
\author{
Ashley Quebrado

C. C. Deocaris
}
