% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jossensanalysis.r
\name{jossensanalysis}
\alias{jossensanalysis}
\title{Jossens Isotherm Non-Linear Analysis}
\usage{
jossensanalysis(Qe, Ce)
}
\arguments{
\item{Qe}{the numerical value for the adsorbed capacity}

\item{Ce}{the numerical value for the equilibrium capacity}
}
\value{
the nonlinear regression, parameters for the Jossens isotherm,
and model error analysis
}
\description{
The Jossens isotherm model predicts a simple equation based on
the energy distribution of adsorbate-adsorbent interactions at adsorption sites.
This model assumes that the adsorbent has heterogeneous surface with respect
to the interactions it has with the adsorbate.
}
\examples{
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
jossensanalysis(Qe, Ce)
}
\references{
Jossens, L., Prausnitz, J. M., Fritz, W., Schl?nder, E. U.,
& Myers, A. L. (1978) <doi:10.1016/0009-2509(78)85015-5> Thermodynamics of
multi-solute adsorption from dilute aqueous solutions.
Chemical Engineering Science, 33(8), 1097-1106.
}
\author{
Paul Angelo C. Manlapaz

Chester C. Deocaris
}
