% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_join.R
\name{monitor_join}
\alias{monitor_join}
\title{Merge Data for Monitors with Shared monitorIDs}
\usage{
monitor_join(ws_monitor1 = NULL, ws_monitor2 = NULL, monitorIDs = NULL)
}
\arguments{
\item{ws_monitor1}{\emph{ws_monitor} object}

\item{ws_monitor2}{\emph{ws_monitor} object}

\item{monitorIDs}{vector of shared monitorIDs that are to be joined together. Defaults to all shared monitorIDs.}
}
\value{
A \emph{ws_monitor} object with merged timeseries.
}
\description{
For each monitor in \code{monitorIDs}, an attempt is made to merge
the associated data from \code{ws_monitor1} and \code{ws_monitor2} and.

This is useful when the same \code{monitorID} appears in different \emph{ws_monitor}
objects representing different time periods. The returned \emph{ws_monitor}
object will cover both time periods.
}
\examples{
\dontrun{
Jul <- monitor_subset(Northwest_Megafires,
                      tlim=c(2015070100,2015073123),
                      timezone='America/Los_Angeles')
Aug <- monitor_subset(Northwest_Megafires,
                      tlim=c(2015080100,2015083123),
                      timezone='America/Los_Angeles')
Methow_Valley <- monitor_join(Jul, Aug, monitorIDs=c('530470010_01','530470009_01'))
}
}
\keyword{ws_monitor}
