% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbToDf.R
\name{pbToDf}
\alias{pbToDf}
\title{Convert a PamBinary Object to Data Frame}
\usage{
pbToDf(pb, templateNames = NULL)
}
\arguments{
\item{pb}{a PamBinary class object created by 
\code{\link[PamBinaries]{loadPamguardBinaryFile}}}

\item{templateNames}{if using the click template classifier, the names of the species
for the click templates. These will be used as the names of the columns in the
dataframe, and the length of this must exactly match the number of templates used.
Will add columns for the threshold, match, and reject correlation values for each
template name provided}
}
\value{
a data.frame containing most of the binary data read in. Will not
  contain most annotation data, click waveforms, DIFAR demux data, or contour
  information from WMD detector. These are skipped because they are either
  incosistent in their size, or are large objects. Click template classifier
  information will be included if \code{templateNames} are supplied. If binary
  is from noise band monitor, noise data will be stored in columns noiseMean,
  noisePeak, and octaveBands, and the resulting dataframe will have a row for 
  each separate octave band stored
}
\description{
Converts a PamBinary object into a data frame. The data.frame
  will combine all of the data from the \code{data} part of the PamBinary
  object, but will not include annotations data, click waveforms, DIFAR demux
  data, or contours from the WMD detector. These are skipped because they are
  either inconsistent in their size, or are large objects. The function 
  \code{pbToDf} is also called when \code{as.data.frame} is called on a PamBinary
  class object.
}
\examples{

# load the data
clickFile <- system.file('extdata', 'Click.pgdf', package='PamBinaries')
clickData <- loadPamguardBinaryFile(clickFile)
# two methods two convert to a dataframe
head(pbToDf(clickData))
head(data.frame(clickData))

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
