% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelEstimateObject.R
\name{print.PanelEstimate}
\alias{print.PanelEstimate}
\title{Print point estimates and standard errors}
\usage{
\method{print}{PanelEstimate}(x, ...)
}
\arguments{
\item{x}{\code{PanelEstimate} object}

\item{...}{additional arguments to be passed to \code{print.data.frame()}}
}
\description{
Print point estimates and standard errors
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
dem.sub.panel <- PanelData(dem.sub, "wbcode2", "year", "dem", "y")
# create subset of data for simplicity
PM.results <- PanelMatch(panel.data = dem.sub.panel, lag = 4, 
                         refinement.method = "ps.match", 
                         match.missing = TRUE, 
                         covs.formula = ~ tradewb,
                         size.match = 5, qoi = "att",
                         lead = 0:4, 
                         forbid.treatment.reversal = FALSE)
PE.results <- PanelEstimate(sets = PM.results, 
              panel.data = dem.sub.panel, 
              se.method = "unconditional")
print(PE.results)
}
