% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Preprocessing.R
\name{Preprocessing}
\alias{Preprocessing}
\title{As a data preprocessing function, sets some global variables that are not visible to the user}
\usage{
Preprocessing(Fpath, FEncoding, nblock, ncore, foldername, sample.name)
}
\arguments{
\item{Fpath}{: the path of file}

\item{FEncoding}{: the encoding of file}

\item{nblock}{: the number of blocks for data cutting}

\item{ncore}{: Computes the CPU's kernel in parallel(fill in according to the computer configuration)}

\item{foldername}{: Name of the folder in which the soil data is stored}

\item{sample.name}{: Standard soil files, which can be used as sample files (under in the FolderName)}
}
\description{
As a data preprocessing function, sets some global variables that are not visible to the user
}
\examples{
mydatas <- system.file("extdata", "all.input.csv", package = "ParallelDSM")
sampledatas <- system.file("extdata", "covariate", package = "ParallelDSM")
Preprocessing(mydatas,1,2,2,sampledatas,"twi.tif")
}
\references{
Breiman, L. (2001). Random forests. Mach. Learn. 45, 5–32.
Meinshausen, N. (2006) "Quantile Regression Forests", Journal of Machine Learning Research 7,
983-999 http://jmlr.csail.mit.edu/papers/v7/
Song, X.D., Ge, G.Q., Zhang, G.L. and Wu, H.Y. ParallelDSM: A R package for parallel soil mapping. Computers & Geosciences (to be available in 2021)
}
