% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateRandomDesign.R
\name{generateRandomDesign}
\alias{generateRandomDesign}
\title{Generates a random design for a parameter set.}
\usage{
generateRandomDesign(n = 10L, par.set, trafo = FALSE)
}
\arguments{
\item{n}{[\code{integer(1)}]\cr
Number of samples in design.
Default is 10.}

\item{par.set}{[\code{\link{ParamSet}}]\cr
Parameter set.}

\item{trafo}{[\code{logical(1)}]\cr
Transform all parameters by using theirs respective transformation functions.
Default is \code{FALSE}.}
}
\value{
[\code{data.frame}]. Columns are named by the ids of the parameters.
  If the \code{par.set} argument contains a vector parameter, its corresponding column names
  in the design are the parameter id concatenated with 1 to dimension of the vector.
  The result will have an \code{logical(1)} attribute \dQuote{trafo},
  which is set to the value of argument \code{trafo}.
}
\description{
The following types of columns are created:
\tabular{ll}{
 numeric(vector)   \tab  \code{numeric}  \cr
 integer(vector)   \tab  \code{integer}  \cr
 discrete(vector)  \tab  \code{factor} (names of values = levels) \cr
 logical(vector)   \tab  \code{logical}
}
If you want to convert these, look at \code{\link[BBmisc]{convertDataFrameCols}}.
Dependent parameters whose constraints are unsatisfied generate \code{NA} entries in their
respective columns.

The algorithm simply calls \code{\link{sampleValues}} and arranges the result in a data.frame.

\code{generateRandomDesign} will NOT work if there are dependencies over multiple levels of
parameters and the dependency is only given with respect to the \dQuote{previous} parameter.
A current workaround is to state all dependencies on all parameters involved.
(We are working on it.)
}

