% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partiallyoverlapping.R
\name{Partover.test}
\alias{Partover.test}
\title{The partially overlapping samples t-test}
\usage{
Partover.test(x1 = NULL, x2 = NULL, x3 = NULL, x4 = NULL,
  var.equal = FALSE, alternative = "two.sided", conf.level = NULL,
  stacked = FALSE)
}
\arguments{
\item{x1}{a vector of unpaired observations in Sample 1 (or all observations in Sample 1 if stacked = "TRUE")}

\item{x2}{a vector of unpaired observations in Sample 2 (or all observations in Sample 2 if stacked = "TRUE")}

\item{x3}{a vector of paired observations in Sample 1 (not applicable if stacked = "TRUE")}

\item{x4}{a vector of paired observations in Sample 2 (not applicable if stacked = "TRUE")}

\item{var.equal}{a logical variable indicating whether to treat the two variances as being equal. If "TRUE" then the pooled variance is used to estimate the variance, otherwise the Welch approximation to the degrees of freedom is used.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the interval.}

\item{stacked}{indicator of whether paired and unpaired observations are stacked within one vector ("TRUE"), or if specified as four separate vectors (default)}
}
\value{
A list which contains the following components of the test:

statistic  ~~ The value of the t-statistic

parameter  ~~ The degrees of freedom for the test statistic

p.value  ~~ The p-value for the test

estimate ~~ The estimated difference in the means

conf.int ~~ A confidence interval for the mean appropriate to the specified alternative hypothesis
}
\description{
Performs a comparison of means using the partially overlapping t-test, for two samples each with paired and unpaired observations.
This functions calculates the test statistic, the degrees of freedom, and the p-value. Additionally calculates a confidence interval for the difference in means when requested.
 
By default, four vectors are to be specified: unpaired observations in Sample 1, unpaired observations in Sample 2, paired observations in Sample 1, paired observations in Sample 2.
If the structure of your data is of two vectors, one for each sample, then the option stacked = TRUE can be specified.
}
\details{
The formula is only applicable for the 2 sample partially overlapping samples t-test. The number of unpaired observations may be zero for up to one of the two samples. The number of paired observations must be of equal length of two or greater. Error messages are generated when these conditions are not true

If your observations are from a datframe of two paired samples with missing observations, use the option "stacked=TRUE". Correpsonding pairs should be given on the same row when this option is applied.
}
\examples{
#The sample means for two groups, "a" and "b" are compared
#for a two sided test assuming equal variances.

#Approach 1:
#For each sample, unpaired observations and paired observations defined as separate vectors:
a.unpaired<-c(20,21,16,18,14,12,14,17)
a.paired<-c(14,15,18,20,11,19,14,15)
b.unpaired<-c(10,16,18,16,15,14,13,10)
b.paired<-c(15,10,15,17,13,19,12,13)
Partover.test(a.unpaired,b.unpaired,a.paired,b.paired,var.equal=TRUE) 
#p.value = 0.026, the samples from group "a" and group "b" have significantly different means

#Equivalently, Approach 2:
#Independent observations and the paired samples stacked for each sample:
a<-c(20,21,16,18,14,12,14,17,NA,NA,NA,NA,NA,NA,NA,NA,14,15,18,20,11,19,14,15)
b<-c(NA,NA,NA,NA,NA,NA,NA,NA,10,16,18,16,15,14,13,10,15,10,15,17,13,19,12,13)
Partover.test(a,b,var.equal=TRUE,stacked=TRUE) 
#p.value = 0.026, the samples from group "a" and group "b" have significantly different means
}

