% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMethods.R
\docType{methods}
\name{getPathwaySpace,PathwaySpace-method}
\alias{getPathwaySpace,PathwaySpace-method}
\alias{getPathwaySpace}
\title{Accessors for Fetching Slots from a PathwaySpace Object}
\usage{
\S4method{getPathwaySpace}{PathwaySpace}(ps, what = "status")
}
\arguments{
\item{ps}{A preprocessed \linkS4class{PathwaySpace} class object}

\item{what}{A single character value specifying which information should 
be retrieved from the slots.
Options: "nodes", "edges", "graph", "image", "pars", "misc", 
"signal","projections", "status", "silhouette", "summits", 
"summit_mask", "summit_contour"}
}
\value{
Content from slots in the \linkS4class{PathwaySpace} object.
}
\description{
\code{getPathwaySpace} retrives information from
individual slots available in a PathwaySpace object.
}
\examples{
# Load a demo igraph
data('gtoy1', package = 'RGraphSpace')

# Create a new PathwaySpace object
ps <- buildPathwaySpace(gtoy1, nrc = 100)
# note: adjust 'nrc' to increase image resolution

# Get the 'status' slot in ps
status <- getPathwaySpace(ps, what = 'status')

}
