#' @name K
#' @docType data
#' @title The 10 factors from Kidera et al (1985)
#' @description The Kidera Factors were originally derived by applying multivariate analysis to 188 physical properties of the 20 amino acids and using dimension reduction techniques. A 10-dimensional vector of orthogonal factors was then obtained for each amino acid.
#' @usage data(K)
#' @format A list with the ten Kidera factors of the 20 amino acids. The first four factors are essentially pure physical properties; the remaining six factors are superpositions of several physical properties, and are labelled for convenience by the name of the most heavily weighted component.
#' \itemize{\item{Helix/bend preference},
#' \item{Side-chain size},
#' \item{Extended structure preference},
#' \item{Hydrophobicity},
#' \item{Double-bend preference},
#' \item{Partial specific volume},
#' \item{Flat extended preference},
#' \item{Occurrence in alpha region},
#' \item{pK-C},
#' \item{Surrounding hydrophobicity}}
#' @references Kidera, A., Konishi, Y., Oka, M., Ooi, T., & Scheraga, H. A. (1985). Statistical analysis of the physical properties of the 20 naturally occurring amino acids. Journal of Protein Chemistry, 4(1), 23-55.
NULL