% Generated by roxygen2 (4.0.2): do not edit by hand
\name{chart.StackedBar}
\alias{chart.StackedBar}
\title{create a stacked bar plot}
\usage{
chart.StackedBar(w, colorset = NULL, space = 0.2, cex.axis = 0.8,
  cex.legend = 0.8, cex.lab = 1, cex.labels = 0.8, cex.main = 1,
  xaxis = TRUE, legend.loc = "under", element.color = "darkgray",
  unstacked = TRUE, xlab = "Date", ylab = "Value", ylim = NULL,
  date.format = "\%b \%y", major.ticks = "auto", minor.ticks = TRUE,
  las = 0, xaxis.labels = NULL, ...)
}
\arguments{
\item{w}{a matrix, data frame or zoo object of values to be plotted.
Rownames should contain dates or period labels; column names should indicate
categories.  See examples for detail.}

\item{colorset}{color palette to use, set by default to rational choices}

\item{space}{the amount of space (as a fraction of the average bar width)
left before each bar, as in \code{\link{barplot}}. Default is 0.2.}

\item{cex.axis}{The magnification to be used for sizing the axis text
relative to the current setting of 'cex', similar to \code{\link{plot}}.}

\item{cex.legend}{The magnification to be used for sizing the legend
relative to the current setting of 'cex', similar to \code{\link{plot}}.}

\item{cex.lab}{The magnification to be used for x- and y-axis labels
relative to the current setting of 'cex'.}

\item{cex.labels}{The magnification to be used for event line labels
relative to the current setting of 'cex'.}

\item{cex.main}{The magnification to be used for the chart title relative to
the current setting of 'cex'.}

\item{xaxis}{If true, draws the x axis}

\item{legend.loc}{places a legend into a location on the chart similar to
\code{\link{chart.TimeSeries}}. The default, "under," is the only location
currently implemented for this chart.  Use 'NULL' to remove the legend.}

\item{element.color}{provides the color for drawing less-important chart
elements, such as the box lines, axis lines, etc.}

\item{unstacked}{logical.  If set to 'TRUE' \emph{and} only one row of data
is submitted in 'w', then the chart creates a normal column chart.  If more
than one row is submitted, then this is ignored.  See examples below.}

\item{xlab}{the x-axis label, which defaults to 'NULL'.}

\item{ylab}{Set the y-axis label, same as in \code{\link{plot}}}

\item{ylim}{set the y-axis limit, same as in \code{\link{plot}}}

\item{date.format}{Re-format the dates for the xaxis; the default is "\%m/\%y"}

\item{major.ticks}{Should major tickmarks be drawn and labeled, default
'auto'}

\item{minor.ticks}{Should minor tickmarks be drawn, default TRUE}

\item{las}{sets the orientation of the axis labels, as described in
\code{\link{par}}.  Defaults to '3'.}

\item{xaxis.labels}{Allows for non-date labeling of date axes, default is
NULL}

\item{\dots}{arguments to be passed to \code{\link{barplot}}.}
}
\description{
This creates a stacked column chart with time on the horizontal axis and
values in categories.  This kind of chart is commonly used for showing
portfolio 'weights' through time, although the function will plot any values
by category.
}
\details{
This function is a wrapper for \code{\link{barplot}} but adds three
additional capabilities.  First, it calculates and sets a bottom margin for
long column names that are rotated vertically.  That doesn't always result
in the prettiest chart, but it does ensure readable labels.

Second, it places a legend "under" the graph rather than within the bounds
of the chart (which would obscure the data).  The legend is created from the
column names.  The default is to create the legend when there's more than
one row of data being presented.  If there is one row of data, the chart may
be "unstacked" and the legend removed.

Third, it plots or stacks negative values from an origin of zero, similar to
the behavior of \code{\link[lattice]{barchart}} from the 'lattice' package.
}
\note{
The 'w' attribute is so named because this is a popular way to show
portfolio weights through time.  That being said, this function isn't
limited to any particular values and doesn't provide any normalization, so
that the chart can be used more generally.

The principal drawback of stacked column charts is that it is very difficult
for the reader to judge size of 2nd, 3rd, etc., data series because they do
not have common baseline.  Another is that with a large number of series,
the colors may be difficult to discern.  As alternatives, Cleveland
advocates the use of trellis like displays, and Tufte advocates the use of
small multiple charts.
}
\examples{
data(weights)
head(weights)

# With the legend "under" the chart
chart.StackedBar(weights, date.format="\\\%Y", cex.legend = 0.7, colorset=rainbow12equal)

# Without the legend
chart.StackedBar(weights, colorset=rainbow12equal, legend.loc=NULL)

# for one row of data, use 'unstacked' for a better chart
chart.StackedBar(weights[1,,drop=FALSE], unstacked=TRUE, las=3)
}
\author{
Peter Carl
}
\references{
Cleveland, W.S. (1994), The Elements of Graphing Data, Summit,
NJ: Hobart Press.

Tufte, Edward R. (2001) The Visual Display of Quantitative Information, 2nd
edition. The Graphics Press, Cheshire, Connecticut. See
http://www.edwardtufte.com for this and other references.
}
\seealso{
\code{\link{barplot}}, \code{\link{par}}
}

