% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RachevRatio.R
\name{RachevRatio}
\alias{RachevRatio}
\title{Standard Error Estimate for Rachev Ratio of Returns}
\usage{
RachevRatio(
  R,
  alpha = 0.1,
  beta = 0.1,
  rf = 0,
  SE = FALSE,
  SE.control = NULL,
  ...
)
}
\arguments{
\item{R}{Data of returns for one or multiple assets or portfolios.}

\item{alpha}{Lower tail probability.}

\item{beta}{Upper tail probability.}

\item{rf}{Risk-free interest rate.}

\item{SE}{TRUE/FALSE whether to ouput the standard errors of the estimates of the risk measures, default FALSE.}

\item{SE.control}{Control parameters for the computation of standard errors. Should be done using the \code{\link{RPESE.control}} function.}

\item{...}{Additional parameters.}
}
\value{
A vector or a list depending on \code{se.method}.
}
\description{
\code{RachevRatio.SE} computes the standard error of the Rachev ratio of the returns.
}
\examples{
# Loading data from PerformanceAnalytics
data(edhec, package = "PerformanceAnalytics")
class(edhec)
# Changing the data colnames
names(edhec) = c("CA", "CTA", "DIS", "EM", "EMN",
                 "ED", "FIA", "GM", "LS", "MA",
                 "RV", "SS", "FOF")
# Compute Rachev ratio for managers data
RachevRatio(edhec)

}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
