% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_load_indicator.R
\name{compute_pesticide_load_indicator_ppdb}
\alias{compute_pesticide_load_indicator_ppdb}
\title{Compute Pesticide Load Indicator using the Pesticide Properties database}
\usage{
compute_pesticide_load_indicator_ppdb(substances, products, folder)
}
\arguments{
\item{substances}{Dataframe describing active ingredients of the applied pesticide products and their CAS number.}

\item{products}{Dataframe with raw pesticide application data.}

\item{folder}{Folder with exported xlsx files from PPDB containing information on active ingredient properties.}
}
\value{
Dataframe with pesticide indicators for each pesticide application
indicated in the products dataframe.
Computes Pesticide Load Indicator (L) and its subindicators:
The Human Health Load (HL), Ecotoxicity Load (TL) and Fate Load (FL).
}
\description{
Compute Pesticide Load Indicator using the Pesticide Properties database
}
\examples{
\dontrun{
# load the dataframe containing the pesticide use data.
products_ppdb <- products.load()[,c("product","crop","standard.dosage","formula")]
# Add information on the year in which the product is used.
products_ppdb$Year <- c(2009,2010,2011,2012)

# load the (user-supplied) dataframe with information on used pesticides
substances_ppdb <- substances.load()[,c("substance","product","concentration")]

# Add the CAS number of each active ingredient to link to the Pesticide Properties database.
substances_ppdb$CAS.number <- c("94361-06-5","141517-21-7","111988-49-9","467-69-6",
                                "1918-00-9","94-74-6","21087-64-9","142459-58-3")

Load.factors <- c("Load.Factor.SCI","Load.Factor.BCF","Load.Factor.SoilDT50",
       "Load.Factor.Birds","Load.Factor.Mammals","Load.Factor.Fish",
       "Load.Factor.Aquatic.Invertebrates","Load.Factor.Algae","Load.Factor.Aquatic.Plants",
       "Load.Factor.Earthworms","Load.Factor.Bees","Load.Factor.Fish.Chronic",
       "Load.Factor.Aquatic.Invertebrates.Chronic","Load.Factor.Earthworms.Chronic")
# Add the Load factors as defined in the Danish Pesticide Load indicator.
# Alternatively supply own values for the Load factor.
for (i in 1:length(Load.factors)){
  substances_ppdb[,Load.factors[i]]<- rep(times=dim(substances_ppdb)[[1]],
                                          substances.load()[1,Load.factors[i]])
}
# Indicate the folder containing the "General","Fate", "Human" and "Ecotox" tables of the PPPDB.
# Excel files (under the exact same name, e.g. Human.xlsx) are required.
# Attention, a licensed access to the PPPDB (Lewis et al., 2016) is required.
# Note that the "Fate" table should include a column indicating the "SCI.GROW" values.
folder <- "path"

# Compute the Pesticide Load Indicator and its sub-indicators using the user supplied data.
indicators_ppdb  <- compute_pesticide_load_indicator_ppdb(substances = substances_ppdb,
products= products_ppdb, folder=folder)
}
}
