pkgname <- "PhViD"
source(file.path(R.home("share"), "R", "examples-header.R"))
options(warn = 1)
library('PhViD')

base::assign(".oldSearch", base::search(), pos = 'CheckExEnv')
cleanEx()
nameEx("BCPNN")
### * BCPNN

flush(stderr()); flush(stdout())

### Name: BCPNN
### Title: Bayesian confidence propagation neural network
### Aliases: BCPNN
### Keywords: htest

### ** Examples

## start
data(PhViDdata.frame)
PhViDdata <- as.PhViD(PhViDdata.frame)
res <- BCPNN(PhViDdata)
## end



cleanEx()
nameEx("GPS")
### * GPS

flush(stderr()); flush(stdout())

### Name: GPS
### Title: Gamma Poisson Shrinkage
### Aliases: GPS
### Keywords: htest

### ** Examples

## start
#data(PhViDdata.frame)


#PhViDdata <- as.PhViD(PhViDdata.frame)
#res <- GPS(PhViDdata)

#List of signals generated by the decision rule proposed 
#by Szarfman et al. (2002)
#res2 <- GPS(PhViDdata, DECISION = 3, DECISION.THRES = 2, RANKSTAT = 2)
## end



cleanEx()
nameEx("PRR")
### * PRR

flush(stderr()); flush(stdout())

### Name: PRR
### Title: Proportional Reporting Ratio
### Aliases: PRR
### Keywords: htest

### ** Examples

## start
data(PhViDdata.frame)
PhViDdata <- as.PhViD(PhViDdata.frame)
# res <- PRR(PhViDdata)
## end



cleanEx()
nameEx("RFET")
### * RFET

flush(stderr()); flush(stdout())

### Name: RFET
### Title: Reporting Fisher's Exact Test
### Aliases: RFET
### Keywords: htest

### ** Examples

## start
#data(PhViDdata.frame)
#PhViDdata <- as.PhViD(PhViDdata.frame)
#res <- RFET(PhViDdata)
## end



cleanEx()
nameEx("ROR")
### * ROR

flush(stderr()); flush(stdout())

### Name: ROR
### Title: Reporting Odds Ratio
### Aliases: ROR
### Keywords: htest

### ** Examples

## start
data(PhViDdata.frame)
PhViDdata <- as.PhViD(PhViDdata.frame)
res <- ROR(PhViDdata, MIN.n11 = 3)

# Decision rule proposed by van Puijenbroek et al. (2002)
# res2 <- ROR(PhViDdata, MIN.n11 = 1, DECISION=3, DECISION.THRES=0, RANKSTAT=2)
## end



### * <FOOTER>
###
base::cat("Time elapsed: ", proc.time() - base::get("ptime", pos = 'CheckExEnv'),"\n")
grDevices::dev.off()
###
### Local variables: ***
### mode: outline-minor ***
### outline-regexp: "\\(> \\)?### [*]+" ***
### End: ***
quit('no')
