#' Connectivity Map Example PharmacoSet
#'
#' A small example version of the Connectivity Map PharmacoSet, used in the
#' documentation examples. All credit for the data goes to the Connectivity Map
#' group at the Broad Institute.
#' 
#' @references
#' Lamb et al. The Connectivity Map: using gene-expression signatures to connect small molecules, genes, and disease. Science, 2006.
#' 
#' @docType data
#' @name CMAPsmall
#' @usage data(CMAPsmall)
#' @keywords dataset
#' @format PharmacoSet object
#'
NULL

#' Cancer Genome Project Example PharmacoSet
#'
#' A small example version of the Cancer Genome Project PharmacoSet, used in the
#' documentation examples. All credit for the data goes to the Cancer Genome Project
#' group at the Sanger.
#' 
#' @references
#' Garnett et al. Systematic identification of genomic markers of drug sensitivity in cancer cells. Nature, 2012.
#' 
#' @docType data
#' @name CGPsmall
#' @usage data(CGPsmall)
#' @keywords dataset
#' @format PharmacoSet object
#'
NULL

#' Cancer Cell Line Encyclopedia (CCLE) Example PharmacoSet
#'
#' A small example version of the CCLE PharmacoSet, used in the
#' documentation examples. All credit for the data goes to the CCLE
#' group at the Broad Institute.
#' 
#' @references
#' Barretina et al. The Cancer Cell Line Encyclopedia enables predictive modelling of anticancer drug sensitivity. Nature, 2012
#' 
#' @docType data
#' @name CCLEsmall
#' @usage data(CCLEsmall)
#' @keywords dataset
#' @format PharmacoSet object
#'
NULL

#' HDAC Gene Signature
#'
#' A gene signature for HDAC inhibitors, as detailed by Glaser et al. The 
#' signature is mapped from the probe to gene level using
#' \code{probeGeneMapping}
#' 
#' @references
#' Glaser et al. Gene expression profiling of multiple histone deacetylase (HDAC) inhibitors: defining a common gene set produced by HDAC inhibition in T24 and MDA carcinoma cell lines. Molecular cancer therapeutics, 2003.
#' 
#' @docType data
#' @name HDAC_genes
#' @usage data(HDAC_genes)
#' @keywords dataset
#' @format a 13x2 data.frame with gene identifiers in the first column and
#'   direction change in the second
#'
NULL