% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PharmacoSetClass.R
\docType{class}
\name{PharmacoSet-class}
\alias{.PharmacoSet}
\alias{PharmacoSet-class}
\alias{cellInfo,PharmacoSet-method}
\alias{cellInfo<-,PharmacoSet,data.frame-method}
\alias{cellNames,PharmacoSet-method}
\alias{cellNames<-,PharmacoSet,character-method}
\alias{dateCreated,PharmacoSet-method}
\alias{drugInfo,PharmacoSet-method}
\alias{drugInfo<-,PharmacoSet,data.frame-method}
\alias{drugNames,PharmacoSet-method}
\alias{drugNames<-,PharmacoSet,character-method}
\alias{featureInfo,PharmacoSet-method}
\alias{featureInfo<-,PharmacoSet,character,data.frame-method}
\alias{featureNames,PharmacoSet-method}
\alias{molecularProfiles,PharmacoSet-method}
\alias{molecularProfiles<-,PharmacoSet,character,matrix-method}
\alias{pSetName,PharmacoSet-method}
\alias{pertNumber,PharmacoSet-method}
\alias{pertNumber<-,PharmacoSet,array-method}
\alias{phenoInfo,PharmacoSet-method}
\alias{phenoInfo<-,PharmacoSet,character,data.frame-method}
\alias{sensNumber,PharmacoSet-method}
\alias{sensNumber<-,PharmacoSet,matrix-method}
\alias{sensitivityInfo,PharmacoSet-method}
\alias{sensitivityInfo<-,PharmacoSet,data.frame-method}
\alias{sensitivityMeasures,PharmacoSet-method}
\alias{sensitivityProfiles,PharmacoSet-method}
\alias{sensitivityProfiles<-,PharmacoSet,matrix-method}
\title{A Class to Contain PharmacoGenomic datasets together with their curations}
\usage{
\S4method{cellInfo}{PharmacoSet}(pSet)

\S4method{cellInfo}{PharmacoSet,data.frame}(object) <- value

\S4method{drugInfo}{PharmacoSet}(pSet)

\S4method{drugInfo}{PharmacoSet,data.frame}(object) <- value

\S4method{phenoInfo}{PharmacoSet}(pSet, mDataType)

\S4method{phenoInfo}{PharmacoSet,character,data.frame}(object, mDataType) <-
  value

\S4method{molecularProfiles}{PharmacoSet}(pSet, mDataType)

\S4method{molecularProfiles}{PharmacoSet,character,matrix}(object, mDataType) <-
  value

\S4method{featureInfo}{PharmacoSet}(pSet, mDataType)

\S4method{featureInfo}{PharmacoSet,character,data.frame}(object, mDataType) <-
  value

\S4method{sensitivityInfo}{PharmacoSet}(pSet)

\S4method{sensitivityInfo}{PharmacoSet,data.frame}(object) <- value

\S4method{sensitivityProfiles}{PharmacoSet}(pSet)

\S4method{sensitivityProfiles}{PharmacoSet,matrix}(object) <- value

\S4method{sensitivityMeasures}{PharmacoSet}(pSet)

\S4method{drugNames}{PharmacoSet}(pSet)

\S4method{drugNames}{PharmacoSet,character}(object) <- value

\S4method{cellNames}{PharmacoSet}(pSet)

\S4method{cellNames}{PharmacoSet,character}(object) <- value

\S4method{featureNames}{PharmacoSet}(pSet, mDataType)

\S4method{dateCreated}{PharmacoSet}(pSet)

\S4method{pSetName}{PharmacoSet}(pSet)

\S4method{pertNumber}{PharmacoSet}(pSet)

\S4method{sensNumber}{PharmacoSet}(pSet)

\S4method{pertNumber}{PharmacoSet,array}(object) <- value

\S4method{sensNumber}{PharmacoSet,matrix}(object) <- value
}
\arguments{
\item{pSet}{A \code{PharmacoSet} object}

\item{object}{A \code{PharmacoSet} object}

\item{value}{A replacement value}

\item{mDataType}{A \code{character} with the type of molecular data to return/update}
}
\description{
The PharmacoSet (PSet) class was developed to contain and organise large 
PharmacoGenomic datasets, and aid in their metanalysis. It was designed 
primarily to allow bioinformaticians and biologists to work with data at the 
level of genes, drugs and cell lines, providing a more naturally intuitive 
interface and simplifying analyses between several datasets. As such, it was 
designed to be flexible enough to hold datasets of two different natures 
while providing a common interface. The class can accomidate datasets 
containing both drug dose response data, as well as datasets contaning 
genetic profiles of cell lines pre and post treatement with compounds, known 
respecitively as sensitivity and perturbation datasets.
}
\section{Methods (by generic)}{
\itemize{
\item \code{cellInfo}: Returns the annotations for all the cell lines tested on in the PharmacoSet

\item \code{cellInfo<-}: Update the cell line annotations

\item \code{drugInfo}: Returns the annotations for all the drugs tested in the PharmacoSet

\item \code{drugInfo<-}: Update the drug annotations

\item \code{phenoInfo}: Return the experiment info from the given type of molecular data in PharmacoSet

\item \code{phenoInfo<-}: Update the the given type of molecular data experiment info in the PharmacoSet

\item \code{molecularProfiles}: Return the given type of molecular data from the PharmacoSet

\item \code{molecularProfiles<-}: Update the given type of molecular data from the PharmacoSet

\item \code{featureInfo}: Return the feature info for the given molecular data

\item \code{featureInfo<-}: Replace the gene info for the molecular data

\item \code{sensitivityInfo}: Return the drug dose sensitivity experiment info

\item \code{sensitivityInfo<-}: Update the sensitivity experiment info

\item \code{sensitivityProfiles}: Return the phenotypic data for the drug dose sensitivity

\item \code{sensitivityProfiles<-}: Update the phenotypic data for the drug dose
sensitivity

\item \code{sensitivityMeasures}: Returns the available sensitivity profile
summaries, for example, whether there are IC50 values available

\item \code{drugNames}: Return the names of the drugs used in the PharmacoSet

\item \code{drugNames<-}: Update the drug names used in the dataset

\item \code{cellNames}: Return the cell names used in the dataset

\item \code{cellNames<-}: Update the cell names used in the dataset

\item \code{featureNames}: Return the feature names used in the dataset

\item \code{dateCreated}: Return the date the PharmacoSet was created

\item \code{pSetName}: Return the name of the PharmacoSet

\item \code{pertNumber}: Return the summary of available perturbation
experiments

\item \code{sensNumber}: Return the summary of available sensitivity
experiments

\item \code{pertNumber<-}: Update the summary of available perturbation
experiments

\item \code{sensNumber<-}: Update the summary of available sensitivity
experiments
}}
\section{Slots}{

\describe{
\item{\code{annotation}}{A \code{list} of annotation data about the PharmacoSet,
including the \code{$name} and the session information for how the object
was creating, detailing the exact versions of R and all the packages used}

\item{\code{molecularProfiles}}{A \code{list} containing 4 \code{Biobase::ExpressionSet} 
type object for holding data for RNA, DNA, SNP and Copy Number Variation 
measurements respectively, with associated \code{fData} and \code{pData} 
containing the row and column metadata}

\item{\code{cell}}{A \code{data.frame} containg the annotations for all the cell 
lines profiled in the data set, across all data types}

\item{\code{drug}}{A \code{data.frame} containg the annotations for all the drugs 
profiled in the data set, across all data types}

\item{\code{sensitivity}}{A \code{list} containing all the data for the sensitivity 
experiments, including \code{$info}, a \code{data.frame} containing the 
experimental info,\code{$raw} a 3D \code{array} containing raw data, 
\code{$profiles}, a \code{data.frame} containing sensitivity profiles 
statistics, and \code{$n}, a \code{data.frame} detailing the number of 
experiments for each cell-drug pair}

\item{\code{perturbation}}{A \code{list} containting \code{$n}, a \code{data.frame} 
summarizing the available perturbation data,}

\item{\code{curation}}{A \code{list} containing mappings for \code{$drug}, 
\code{cell}, \code{tissue} names  used in the data set to universal 
identifiers used between different PharmacoSet objects}

\item{\code{datasetType}}{A \code{character} string of 'sensitivity', 
'preturbation', or both detailing what type of data can be found in the 
PharmacoSet, for proper processing of the data}
}}

