% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReturnMeanControl.R
\name{ReturnMeanControl}
\alias{ReturnMeanControl}
\title{Gives true mean survival times for the control therapy.}
\usage{
ReturnMeanControl(ProbC, betaC, Family, alpha)
}
\arguments{
\item{ProbC}{Probability of efficacy and toxicity for the control therapy.}

\item{betaC}{Linear term for efficacy, toxicity and beta_0 for the control groupar term for efficacy, toxicity and beta_0 for the control group.}

\item{Family}{Time to event distribution. Options include: Exponential, Gamma, Weibull, Lognormal.}

\item{alpha}{Shape parameter or standard deviation of a lognormal distribution.}
}
\description{
Returns the mean survival times for the control given efficacy and toxicity dose probability vector, distribution family and linear relationship, effiacy, toxicity and survival.
}
\examples{
###Family of Distributions
Family="Gamma"
###Shape parameter
alpha=2
##True beta vector for efficacy, toxicity and intercept of the control treatment
betaC=c(.3,-.25,2.389)
##True efficacy and toxicity probability for control group
ProbC = c(.4,.15)
ReturnMeanControl(ProbC,betaC,Family,alpha)
}
\references{
[1] Chapple and Thall (2018).A Hybrid Phase I-II/III Clinical Trial Design Allowing Dose Re-Optimization in Phase III. Biometrics. In Press,
}
