% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{PieceMCMC}
\alias{PieceMCMC}
\title{Returns posterior distribution for key mixture model parameters}
\usage{
PieceMCMC(Y, I, YE, YT, Doses, Dose, B, prob, MaxObs)
}
\arguments{
\item{Y}{Patient survival or followup times.}

\item{I}{Patient event indicators.}

\item{YE}{Vector of indicators for patient efficacy.}

\item{YT}{Vector of indicators for patient toxicity.}

\item{Doses}{Vector of standardized doses given to patients.}

\item{Dose}{Vector of standardized doses considered in trial.}

\item{B}{Number of iterations to perform in MCMC.}

\item{prob}{length(Doses) X 4 matrix containing the estimated posterior probabilities for each dose and each (Efficacy, Toxicity) outcomes.}

\item{MaxObs}{length(Doses) X 4 matrix containing the maximum observed survival time we want to evaluate the means to.}
}
\value{
Returns a list containing a matrix of posterior means for each dose, regression coefficients in the cox models, locations of the split points, log hazard heights on each interval, and the number of intervals in the baseline hazard.
}
\description{
This function performs MCMC with Metropolis-Hastings-Green steps for the baseline hazard function and is used in the functions Reoptimize, SimPhase123 and SimPhase3.
}
\examples{
n=100
Y=rexp(n,1)
I = rbinom(n,1,.9)
YE = rbinom(n,1,.5)
YT = rbinom(n,1,.5)
Dose = c(1,2,3,3.5,5)
Dose=(Dose-mean(Dose))/sd(Dose)
Doses = sample(1:5,n,replace=TRUE)
Doses=Dose[Doses]
B=2000
MaxObs = matrix(rep(0,length(Dose)*4),nrow=4)
prob=matrix(rep(0,length(Dose)*4),ncol=4)
prob=prob+1/4
MaxObs=MaxObs+max(Y)
G=PieceMCMC(Y,I,YE,YT,Doses,Dose,B,prob,MaxObs)
}
