# Generated by OmopViewer 0.1.0
# Be careful editing this file

ui <- bslib::page_navbar(
  theme = bs_theme(bootswatch = "pulse"),
  #  zephyr

  title = "PhenotypeR",
  bslib::nav_panel(
    title = "Background",
    icon = shiny::icon("disease"),
    shiny::includeMarkdown(path = "background.md")

  ),
  # Database diagnostics -----
  bslib::nav_menu(
    title = "Database diagnostics",
    icon = shiny::icon("list"),
    ## snapshot -----
    bslib::nav_panel(
      title = "Snapshot",
      icon = shiny::icon("clipboard-list"),
            bslib::card(
              full_screen = TRUE,
              bslib::card_header(
                bslib::popover(
                  shiny::icon("download"),
                  shinyWidgets::pickerInput(
                    inputId = "summarise_omop_snapshot_gt_17_download_type",
                    label = "File type",
                    selected = "docx",
                    choices = c("docx", "png", "pdf", "html"),
                    multiple = FALSE
                  ),
                  shiny::downloadButton(outputId = "summarise_omop_snapshot_gt_17_download", label = "Download")
                ),
                class = "text-end"
              ),
                gt::gt_output("summarise_omop_snapshot_gt_17") |> withSpinner()
            )
    ),
    ## observation periods -----
    bslib::nav_panel(
      title = "Observation periods",
      icon = shiny::icon("eye"),
        bslib::nav_panel(
            title = "Table observation period",
            bslib::card(
              full_screen = TRUE,
              bslib::card_header(
                bslib::popover(
                  shiny::icon("download"),
                  shinyWidgets::pickerInput(
                    inputId = "summarise_observation_period_gt_15_download_type",
                    label = "File type",
                    selected = "docx",
                    choices = c("docx", "png", "pdf", "html"),
                    multiple = FALSE
                  ),
                  shiny::downloadButton(outputId = "summarise_observation_period_gt_15_download", label = "Download")
                ),
                class = "text-end"
              ),
                gt::gt_output("summarise_observation_period_gt_15") |> withSpinner()
            )
          )
    )
  ),
  # Codelist diagnostics -----
  bslib::nav_menu(
    title = "Codelist diagnostics",
    icon = shiny::icon("list"),
    ## achilles code use -----
    bslib::nav_panel(
      title = "Achilles code use",
      icon = shiny::icon("database"),
      bslib::layout_sidebar(
        sidebar = bslib::sidebar(width = 400, open = "closed",
                                 bslib::accordion(
                                   bslib::accordion_panel(
                                     title = "Settings",
                                     shinyWidgets::pickerInput(
                                       inputId = "achilles_code_use_grouping_cdm_name",
                                       label = "Database",
                                       choices = NULL,
                                       selected = NULL,
                                       multiple = TRUE,
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     ),
                                     shinyWidgets::pickerInput(
                                       inputId = "achilles_code_use_grouping_codelist_name",
                                       label = "Codelist name",
                                       choices = NULL,
                                       selected = NULL,
                                       multiple = TRUE,
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     )
                                   ),
                                   bslib::accordion_panel(
                                     title = "Table formatting",
                                     sortable::bucket_list(
                                       header = NULL,
                                       sortable::add_rank_list(
                                         text = "none",
                                         labels = c( "codelist_name"),
                                         input_id = "achilles_code_use_none"
                                       ),
                                       sortable::add_rank_list(
                                         text = "header",
                                         labels = c("cdm_name", "estimate_name"),
                                         input_id = "achilles_code_use_header"
                                       ),
                                       sortable::add_rank_list(
                                         text = "groupColumn",
                                         labels = NULL,
                                         input_id = "achilles_code_use_groupColumn"
                                       ),
                                       sortable::add_rank_list(
                                         text = "hide",
                                         labels = character(),
                                         input_id = "achilles_code_use_hide"
                                       )
                                     )
                                   )
                                 )
        ),
        bslib::nav_panel(
          title = "achilles_code_use",
          bslib::card(
            full_screen = TRUE,
            bslib::card_header(
              bslib::popover(
                shiny::icon("download"),
                shinyWidgets::pickerInput(
                  inputId = "achilles_code_use_formatted_download_type",
                  label = "File type",
                  selected = "docx",
                  choices = c("docx", "png", "pdf", "html"),
                  multiple = FALSE
                ),
                shiny::downloadButton(outputId = "achilles_code_use_formatted_download", label = "Download")
              ),
              class = "text-end"
            ),
            gt::gt_output("achilles_code_use_gt") |> withSpinner()
          )
        )
      )
    ),

    ## unmapped concepts -----
    # bslib::nav_panel(
    #   title = "Unmapped concepts",
    #   icon = shiny::icon("database"),
    #   bslib::layout_sidebar(
    #     sidebar = bslib::sidebar(width = 400, open = "closed",
    #                              bslib::accordion(
    #                                bslib::accordion_panel(
    #                                  title = "Settings",
    #                                  shinyWidgets::pickerInput(
    #                                    inputId = "unmapped_grouping_cdm_name",
    #                                    label = "Database",
    #                                    choices = NULL,
    #                                    selected = NULL,
    #                                    multiple = TRUE,
    #                                    options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #                                  ),
    #                                  shinyWidgets::pickerInput(
    #                                    inputId = "unmapped_grouping_codelist_name",
    #                                    label = "Codelist name",
    #                                    choices = NULL,
    #                                    selected = NULL,
    #                                    multiple = TRUE,
    #                                    options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #                                  )
    #                                ),
    #                                bslib::accordion_panel(
    #                                  title = "Table formatting",
    #                                  sortable::bucket_list(
    #                                    header = NULL,
    #                                    sortable::add_rank_list(
    #                                      text = "none",
    #                                      labels = c( "codelist_name"),
    #                                      input_id = "unmapped_none"
    #                                    ),
    #                                    sortable::add_rank_list(
    #                                      text = "header",
    #                                      labels = c("cdm_name", "estimate_name"),
    #                                      input_id = "unmapped_header"
    #                                    ),
    #                                    sortable::add_rank_list(
    #                                      text = "groupColumn",
    #                                      labels = NULL,
    #                                      input_id = "unmapped_groupColumn"
    #                                    ),
    #                                    sortable::add_rank_list(
    #                                      text = "hide",
    #                                      labels = character(),
    #                                      input_id = "unmapped_hide"
    #                                    )
    #                                  )
    #                                )
    #                              )
    #     ),
    #     bslib::nav_panel(
    #       title = "Unmapped",
    #         bslib::card(
    #           full_screen = TRUE,
    #           bslib::card_header(
    #             bslib::popover(
    #               shiny::icon("download"),
    #               shinyWidgets::pickerInput(
    #                 inputId = "unmapped_formatted_download_type",
    #                 label = "File type",
    #                 selected = "docx",
    #                 choices = c("docx", "png", "pdf", "html"),
    #                 multiple = FALSE
    #               ),
    #               shiny::downloadButton(outputId = "unmapped_formatted_download", label = "Download")
    #             ),
    #             class = "text-end"
    #           ),
    #           gt::gt_output("unmapped_formatted") |> withSpinner()
    #         )
    #     )
    #   )
    # ),

    ## Orphan codes -----
    bslib::nav_panel(
      title = "Orphan codes",
      icon = shiny::icon("circle-half-stroke"),
      bslib::layout_sidebar(
        sidebar = bslib::sidebar(width = 400, open = "closed",
                                 bslib::accordion(
                                   bslib::accordion_panel(
                                     title = "Settings",
                                     shinyWidgets::pickerInput(
                                       inputId = "orphan_grouping_cdm_name",
                                       label = "Database",
                                       choices = NULL,
                                       selected = NULL,
                                       multiple = TRUE,
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     ),
                                     shinyWidgets::pickerInput(
                                       inputId = "orphan_grouping_codelist_name",
                                       label = "Cohort name",
                                       choices = NULL,
                                       selected = NULL,
                                       multiple = TRUE,
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     )
                                   ),
                                   bslib::accordion_panel(
                                     title = "Table formatting",
                                     sortable::bucket_list(
                                       header = NULL,
                                       sortable::add_rank_list(
                                         text = "none",
                                         labels = c("variable_name", "variable_level"),
                                         input_id = "orphan_gt_99_none"
                                       ),
                                       sortable::add_rank_list(
                                         text = "header",
                                         labels = c("cdm_name", "cohort_name", "estimate_name"),
                                         input_id = "orphan_gt_99_header"
                                       ),
                                       sortable::add_rank_list(
                                         text = "groupColumn",
                                         labels = NULL,
                                         input_id = "orphan_gt_99_groupColumn"
                                       ),
                                       sortable::add_rank_list(
                                         text = "hide",
                                         labels = character(),
                                         input_id = "orphan_gt_99_hide"
                                       )
                                     )
                                   )
                                 )),
        bslib::card(
          full_screen = TRUE,
          bslib::card_header(
            bslib::popover(
              shiny::icon("download"),
              shinyWidgets::pickerInput(
                inputId = "orphan_gt_99_download_type",
                label = "File type",
                selected = "docx",
                choices = c("docx", "png", "pdf", "html"),
                multiple = FALSE
              ),
              shiny::downloadButton(outputId = "orphan_gt_99_download", label = "Download")
            ),
            class = "text-end"
          ),
          gt::gt_output("orphan_gt_99") |> withSpinner()
        )


      ))

  ),

  # Cohort diagnostics -----

  bslib::nav_menu(
    title = "Cohort diagnostics",
    icon = shiny::icon("list"),

    ## Cohort code use -----

    bslib::nav_panel(
      title = "Cohort code use",
      icon = shiny::icon("chart-column"),
      bslib::layout_sidebar(
        sidebar = bslib::sidebar(width = 400, open = "closed",
                                 bslib::accordion(
                                   bslib::accordion_panel(
                                     title = "Settings",
                                     shinyWidgets::pickerInput(
                                       inputId = "cohort_code_use_grouping_cdm_name",
                                       label = "Database",
                                       choices = NULL,
                                       selected = NULL,
                                       multiple = TRUE,
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     ),
                                     shinyWidgets::pickerInput(
                                       inputId = "cohort_code_use_grouping_cohort_name",
                                       label = "Cohort name",
                                       choices = NULL,
                                       selected = NULL,
                                       multiple = TRUE,
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     ),
                                     shinyWidgets::pickerInput(
                                       inputId = "cohort_code_use_grouping_domain_id",
                                       label = "Domain id",
                                       choices = NULL,
                                       selected = NULL,
                                       multiple = TRUE,
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     ),
                                     shinyWidgets::pickerInput(
                                       inputId = "cohort_code_use_estimate_name",
                                       label = "Estimate",
                                       choices = NULL,
                                       selected = NULL,
                                       multiple = TRUE,
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     )
                                   ),
                                   bslib::accordion_panel(
                                     title = "Table formatting",
                                     sortable::bucket_list(
                                       header = NULL,
                                       sortable::add_rank_list(
                                         text = "none",
                                         labels = c("cohort_name", "codelist_name", "source_concept_name", "source_concept_id", "domain_id", "variable_name", "variable_level"),
                                         input_id = "cohort_code_use_gt_12_none"
                                       ),
                                       sortable::add_rank_list(
                                         text = "header",
                                         labels = c("cdm_name", "estimate_name"),
                                         input_id = "cohort_code_use_gt_12_header"
                                       ),
                                       sortable::add_rank_list(
                                         text = "groupColumn",
                                         labels = NULL,
                                         input_id = "cohort_code_use_gt_12_groupColumn"
                                       ),
                                       sortable::add_rank_list(
                                         text = "hide",
                                         labels = character(),
                                         input_id = "cohort_code_use_gt_12_hide"
                                       )
                                     )
                                   )
                                 )
        ),
        bslib::nav_panel(
          title = "Table cohort code use",
          bslib::card(
            full_screen = TRUE,
            bslib::card_header(
              bslib::popover(
                shiny::icon("download"),
                shinyWidgets::pickerInput(
                  inputId = "cohort_code_use_gt_12_download_type",
                  label = "File type",
                  selected = "docx",
                  choices = c("docx", "png", "pdf", "html"),
                  multiple = FALSE
                ),
                shiny::downloadButton(outputId = "cohort_code_use_gt_12_download", label = "Download")
              ),
              class = "text-end"
            ),
            gt::gt_output("cohort_code_use_gt_12") |> withSpinner()
          )
        )
      )
    ),
    ## Cohort characteristics -----
  bslib::nav_panel(
      title = "Cohort characteristics",
      icon = shiny::icon("users-gear"),
      bslib::layout_sidebar(
        sidebar = bslib::sidebar(width = 400, open = "closed",
          bslib::accordion(
            bslib::accordion_panel(
              title = "Settings",
              shinyWidgets::pickerInput(
                inputId = "summarise_characteristics_grouping_cdm_name",
                label = "Database",
                choices = NULL,
                selected = NULL,
                multiple = TRUE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              ),
              shinyWidgets::pickerInput(
                inputId = "summarise_characteristics_grouping_cohort_name",
                label = "Cohort name",
                choices = NULL,
                selected = NULL,
                multiple = TRUE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              ),
              shinyWidgets::prettyCheckbox(
                inputId = "summarise_characteristics_include_matched",
                label = "Show matched cohorts",
                value = FALSE)
            ),
            bslib::accordion_panel(
              title = "Table formatting",
            sortable::bucket_list(
              header = NULL,
              sortable::add_rank_list(
                text = "none",
                labels = c("variable_name", "variable_level", "estimate_name"),
                input_id = "summarise_characteristics_gt_7_none"
              ),
              sortable::add_rank_list(
                text = "header",
                labels = c("cdm_name", "cohort_name"),
                input_id = "summarise_characteristics_gt_7_header"
              ),
              sortable::add_rank_list(
                text = "groupColumn",
                labels = NULL,
                input_id = "summarise_characteristics_gt_7_groupColumn"
              ),
              sortable::add_rank_list(
                text = "hide",
                labels = character(),
                input_id = "summarise_characteristics_gt_7_hide"
              )
            )
            )
          )
        ),
            bslib::card(
              full_screen = TRUE,
              bslib::card_header(
                bslib::popover(
                  shiny::icon("download"),
                  shinyWidgets::pickerInput(
                    inputId = "summarise_characteristics_gt_7_download_type",
                    label = "File type",
                    selected = "docx",
                    choices = c("docx", "png", "pdf", "html"),
                    multiple = FALSE
                  ),
                  shiny::downloadButton(outputId = "summarise_characteristics_gt_7_download", label = "Download")
                ),
                class = "text-end"
              ),
                gt::gt_output("summarise_characteristics_gt_7") |> withSpinner()
            )
      )
    ),
  ## Large scale characteristics -----

    bslib::nav_panel(
      title = "Large scale characteristics",
      icon = shiny::icon("arrow-up-right-dots"),
      bslib::layout_sidebar(
        sidebar = bslib::sidebar(width = 400, open = "closed",
          bslib::accordion(
            bslib::accordion_panel(
              title = "Settings",
              shinyWidgets::pickerInput(
                inputId = "summarise_large_scale_characteristics_grouping_cdm_name",
                label = "Database",
                choices = NULL,
                selected = NULL,
                multiple = TRUE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              ),
              shinyWidgets::pickerInput(
                inputId = "summarise_large_scale_characteristics_grouping_cohort_name",
                label = "Cohort name",
                choices = NULL,
                selected = NULL,
                multiple = FALSE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              ),
              shinyWidgets::pickerInput(
                inputId = "summarise_large_scale_characteristics_grouping_domain",
                label = "Domain",
                choices = NULL,
                selected = NULL,
                multiple = FALSE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              ),
              shinyWidgets::pickerInput(
                inputId = "summarise_large_scale_characteristics_grouping_time_window",
                label = "Time window",
                choices = NULL,
                selected = NULL,
                multiple = FALSE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              ),
              shinyWidgets::pickerInput(
                inputId = "summarise_large_scale_characteristics_settings_analysis",
                label = "Concept type",
                choices = NULL,
                selected = NULL,
                multiple = FALSE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              )
            )
          )
        ),
        bslib::navset_card_tab(
          bslib::nav_panel(
            title = "All concepts",
            bslib::card(
              full_screen = TRUE,
              bslib::card_header(
                bslib::popover(
                  shiny::icon("download"),
                  shiny::downloadButton(outputId = "summarise_large_scale_characteristics_tidy_download", label = "Download csv")
                ),
                class = "text-end"
              ),
              bslib::layout_sidebar(
                sidebar = bslib::sidebar(width = 400, open = "closed",
                  shinyWidgets::pickerInput(
                    inputId = "summarise_large_scale_characteristics_tidy_columns",
                    label = "Columns",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                  ),
                  shiny::radioButtons(
                    inputId = "summarise_large_scale_characteristics_tidy_pivot",
                    label = "Pivot estimates/variables",
                    choices = c("none", "estimates", "estimates and variables"),
                    selected = "none"
                  ),
                  position = "right"
                ),
                DT::dataTableOutput("summarise_large_scale_characteristics_tidy")
              )
            )
          ),
          bslib::nav_panel(
            title = "Top concepts",
            bslib::card(
              full_screen = TRUE,
              bslib::card_header(
                bslib::popover(
                  shiny::icon("download"),
                  shinyWidgets::pickerInput(
                    inputId = "summarise_large_scale_characteristics_gt_0_download_type",
                    label = "File type",
                    selected = "docx",
                    choices = c("docx", "png", "pdf", "html"),
                    multiple = FALSE
                  ),
                  shiny::downloadButton(outputId = "summarise_large_scale_characteristics_gt_0_download", label = "Download")
                ),
                class = "text-end"
              ),
              bslib::layout_sidebar(
                sidebar = bslib::sidebar(width = 400, open = "closed",
                  # numericInput("top_n", "Top n:", 10, min = 1, max = 100),
                  sortable::bucket_list(
                    header = NULL,
                    sortable::add_rank_list(
                      text = "none",
                      labels = c("concept_id", "variable_name", "variable_level", "estimate_name", "table_name", "type", "analysis"),
                      input_id = "summarise_large_scale_characteristics_gt_0_none"
                    ),
                    sortable::add_rank_list(
                      text = "header",
                      labels = "cdm_name",
                      input_id = "summarise_large_scale_characteristics_gt_0_header"
                    ),
                    sortable::add_rank_list(
                      text = "group",
                      labels = "cohort_name",
                      input_id = "summarise_large_scale_characteristics_gt_0_group"
                    ),
                    sortable::add_rank_list(
                      text = "hide",
                      labels = character(),
                      input_id = "summarise_large_scale_characteristics_gt_0_hide"
                    )
                  ),
                  position = "right"
                ),
                gt::gt_output("summarise_large_scale_characteristics_gt_0") |> withSpinner()
              )
            )
          )
        )
      )
    ),
  ## Compare large scale characteristics -----
    bslib::nav_panel(
      title = "Compare large scale characteristics",
      icon = shiny::icon("arrow-up-right-dots"),
        bslib::layout_sidebar(
          sidebar = bslib::sidebar(width = 400, open = "closed",
                  bslib::accordion(
                                     bslib::accordion_panel(
                                       title = "Settings",
                                       shinyWidgets::pickerInput(
                                         inputId = "compare_large_scale_characteristics_grouping_cdm_name",
                                         label = "Database",
                                         choices = NULL,
                                         selected = NULL,
                                         multiple = TRUE,
                                         options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                       ),
                                       shinyWidgets::pickerInput(
                                         inputId = "compare_large_scale_characteristics_grouping_cohort_1",
                                         label = "Cohort 1",
                                         choices = NULL,
                                         selected = NULL,
                                         multiple = FALSE,
                                         options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                       ),
                                       shinyWidgets::pickerInput(
                                         inputId = "compare_large_scale_characteristics_grouping_cohort_2",
                                         label = "Cohort 2",
                                         choices = NULL,
                                         selected = NULL,
                                         multiple = FALSE,
                                         options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                       ),
                                       shinyWidgets::pickerInput(
                                         inputId = "compare_large_scale_characteristics_grouping_time_window",
                                         label = "Time window",
                                         choices = NULL,
                                         selected = NULL,
                                         multiple = TRUE,
                                         options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                       ),
                                       shinyWidgets::pickerInput(
                                         inputId = "compare_large_scale_characteristics_grouping_domain",
                                         label = "Domain",
                                         choices = NULL,
                                         selected = NULL,
                                         multiple = TRUE,
                                         options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                       ),
                                       shinyWidgets::pickerInput(
                                         inputId = "compare_large_scale_characteristics_settings_analysis",
                                         label = "Concept type",
                                         choices = NULL,
                                         selected = NULL,
                                         multiple = FALSE,
                                         options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                       ),
                                       shinyWidgets::prettyCheckbox(
                                         inputId = "compare_large_scale_characteristics_impute_missings",
                                         label = "Impute missing values as 0",
                                         value = FALSE)
                                     )
                                   )
        ),
        bslib::navset_card_tab(

          bslib::nav_panel(
            title = "Table",
          bslib::card(
            full_screen = TRUE,
            DT::DTOutput("gt_compare_lsc") |> withSpinner()
          )
          ),
          bslib::nav_panel(
            title = "Plot",
        bslib::card(
          full_screen = TRUE,
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(width = 400, open = "closed",
                                     shinyWidgets::pickerInput(
                                       inputId = "compare_large_scale_characteristics_colour_1",
                                       label = "Colour",
                                       selected = c("table"),
                                       multiple = TRUE,
                                       choices = c("table", "database", "time_window"),
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     ),
                                     shinyWidgets::pickerInput(
                                       inputId = "compare_large_scale_characteristics_facet_1",
                                       label = "Facet",
                                       selected = c("database"),
                                       multiple = TRUE,
                                       choices = c("table", "database", "time_window"),
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     ),
                                     position = "right"
            ),
            position = "right"
          ),
          plotly::plotlyOutput("plotly_compare_lsc") |> withSpinner()
          )
          )
      ))
      ),
  ## Cohort overlap -----
    bslib::nav_panel(
      title = "Cohort overlap",
      icon = shiny::icon("circle-half-stroke"),
      bslib::layout_sidebar(
        sidebar = bslib::sidebar(width = 400, open = "closed",
          bslib::accordion(
            bslib::accordion_panel(
              title = "Settings",
              shinyWidgets::pickerInput(
                inputId = "summarise_cohort_overlap_grouping_cdm_name",
                label = "Database",
                choices = NULL,
                selected = NULL,
                multiple = TRUE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              ),
              shinyWidgets::pickerInput(
                inputId = "summarise_cohort_overlap_grouping_cohort_name_reference",
                label = "Cohort name reference",
                choices = NULL,
                selected = NULL,
                multiple = TRUE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              ),
              shinyWidgets::pickerInput(
                inputId = "summarise_cohort_overlap_grouping_cohort_name_comparator",
                label = "Cohort name comparator",
                choices = NULL,
                selected = NULL,
                multiple = TRUE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              )
            ),
            bslib::accordion_panel(
              title = "Variables",
              shinyWidgets::pickerInput(
                inputId = "summarise_cohort_overlap_variable_name",
                label = "Variable name",
                choices = NULL,
                selected = NULL,
                multiple = TRUE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              )
            ),
            bslib::accordion_panel(
              title = "Estimates",
              shinyWidgets::pickerInput(
                inputId = "summarise_cohort_overlap_estimate_name",
                label = "Estimate name",
                choices = NULL,
                selected = NULL,
                multiple = TRUE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              )
            )
          )
        ),
        bslib::navset_card_tab(
          bslib::nav_panel(
            title = "Table cohort overlap",
            bslib::card(
              full_screen = TRUE,
              bslib::card_header(
                bslib::popover(
                  shiny::icon("download"),
                  shinyWidgets::pickerInput(
                    inputId = "summarise_cohort_overlap_gt_1_download_type",
                    label = "File type",
                    selected = "docx",
                    choices = c("docx", "png", "pdf", "html"),
                    multiple = FALSE
                  ),
                  shiny::downloadButton(outputId = "summarise_cohort_overlap_gt_1_download", label = "Download")
                ),
                class = "text-end"
              ),
              bslib::layout_sidebar(
                sidebar = bslib::sidebar(width = 400, open = "closed",
                  sortable::bucket_list(
                    header = NULL,
                    sortable::add_rank_list(
                      text = "none",
                      labels = c("cohort_name_reference", "cohort_name_comparator", "estimate_name"),
                      input_id = "summarise_cohort_overlap_gt_1_none"
                    ),
                    sortable::add_rank_list(
                      text = "header",
                      labels = "variable_name",
                      input_id = "summarise_cohort_overlap_gt_1_header"
                    ),
                    sortable::add_rank_list(
                      text = "groupColumn",
                      labels = "cdm_name",
                      input_id = "summarise_cohort_overlap_gt_1_groupColumn"
                    ),
                    sortable::add_rank_list(
                      text = "hide",
                      labels = "variable_level",
                      input_id = "summarise_cohort_overlap_gt_1_hide"
                    )
                  ),
                  shiny::checkboxInput(
                    inputId = "summarise_cohort_overlap_gt_1_uniqueCombinations",
                    label = "uniqueCombinations",
                    value = c(TRUE)
                  ),
                  position = "right"
                ),
                gt::gt_output("summarise_cohort_overlap_gt_1") |> withSpinner()
              )
            )
          ),
          # Cohort overlap ----
          bslib::nav_panel(
            title = "Plot cohort overlap",
            bslib::card(
              full_screen = TRUE,
              bslib::card_header(
                bslib::popover(
                  shiny::icon("download"),
                  shiny::numericInput(
                    inputId = "summarise_cohort_overlap_ggplot2_2_download_width",
                    label = "Width",
                    value = 15
                  ),
                  shiny::numericInput(
                    inputId = "summarise_cohort_overlap_ggplot2_2_download_height",
                    label = "Height",
                    value = 10
                  ),
                  shinyWidgets::pickerInput(
                    inputId = "summarise_cohort_overlap_ggplot2_2_download_units",
                    label = "Units",
                    selected = "cm",
                    choices = c("px", "cm", "inch"),
                    multiple = FALSE
                  ),
                  shiny::numericInput(
                    inputId = "summarise_cohort_overlap_ggplot2_2_download_dpi",
                    label = "dpi",
                    value = 300
                  ),
                  shiny::downloadButton(outputId = "summarise_cohort_overlap_ggplot2_2_download", label = "Download")
                ),
                class = "text-end"
              ),
              bslib::layout_sidebar(
                sidebar = bslib::sidebar(width = 400, open = "closed",
                  shinyWidgets::pickerInput(
                    inputId = "summarise_cohort_overlap_ggplot2_2_facet",
                    label = "facet",
                    selected = c("cdm_name", "cohort_name_reference"),
                    multiple = TRUE,
                    choices = c("cdm_name", "cohort_name_reference", "cohort_name_comparator", "variable_name", "variable_level", "estimate_name"),
                    options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                  ),
                  shiny::checkboxInput(
                    inputId = "summarise_cohort_overlap_ggplot2_2_uniqueCombinations",
                    label = "uniqueCombinations",
                    value = c(TRUE)
                  ),
                  position = "right"
                ),
                plotly::plotlyOutput("summarise_cohort_overlap_ggplot2_2")
              )
            )
          )
        )
      )
    )
  ),

  # Population diagnostics -----
  bslib::nav_menu(
    title = "Population diagnostics",
    icon = shiny::icon("list"),
    ## Incidence -----
    bslib::nav_panel(
      title = "Incidence",
      icon = shiny::icon("chart-line"),
      bslib::layout_sidebar(
        sidebar = bslib::sidebar(width = 400, open = "closed",
          bslib::accordion(
            bslib::accordion_panel(
              title = "Settings",
              shinyWidgets::pickerInput(
                inputId = "incidence_grouping_cdm_name",
                label = "Database",
                choices = NULL,
                selected = NULL,
                multiple = TRUE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              ),
              shinyWidgets::pickerInput(
                inputId = "incidence_grouping_outcome_cohort_name",
                label = "Outcome cohort name",
                choices = NULL,
                selected = NULL,
                multiple = TRUE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              ),
              shinyWidgets::pickerInput(
                inputId = "incidence_settings_analysis_interval",
                label = "Time interval",
                choices = NULL,
                selected = NULL,
                multiple = TRUE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              ),
              shinyWidgets::pickerInput(
                inputId = "incidence_settings_denominator_age_group",
                label = "Denominator age group",
                choices = NULL,
                selected = NULL,
                multiple = TRUE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              ),
              shinyWidgets::pickerInput(
                inputId = "incidence_settings_denominator_sex",
                label = "Denominator sex",
                choices = NULL,
                selected = NULL,
                multiple = TRUE,
                options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
              )
            )
          )
        ),
        bslib::navset_card_tab(
          bslib::nav_panel(
            title = "Table incidence",
            bslib::card(
              full_screen = TRUE,
              bslib::card_header(
                bslib::popover(
                  shiny::icon("download"),
                  shinyWidgets::pickerInput(
                    inputId = "incidence_gt_18_download_type",
                    label = "File type",
                    selected = "docx",
                    choices = c("docx", "png", "pdf", "html"),
                    multiple = FALSE
                  ),
                  shiny::downloadButton(outputId = "incidence_gt_18_download", label = "Download")
                ),
                class = "text-end"
              ),
              bslib::layout_sidebar(
                sidebar = bslib::sidebar(width = 400, open = "closed",
                  sortable::bucket_list(
                    header = NULL,
                    sortable::add_rank_list(
                      text = "none",
                      labels = c("cdm_name", "denominator_cohort_name", "incidence_start_date", "incidence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level"),
                      input_id = "incidence_gt_18_none"
                    ),
                    sortable::add_rank_list(
                      text = "header",
                      labels = "estimate_name",
                      input_id = "incidence_gt_18_header"
                    ),
                    sortable::add_rank_list(
                      text = "groupColumn",
                      labels = character(),
                      input_id = "incidence_gt_18_groupColumn"
                    ),
                    sortable::add_rank_list(
                      text = "hide",
                      labels = character(),
                      input_id = "incidence_gt_18_hide"
                    )
                  ),
                  position = "right"
                ),
                gt::gt_output("incidence_gt_18") |> withSpinner()
              )
            )
          ),
          bslib::nav_panel(
            title = "Plot incidence",
            bslib::card(
              full_screen = TRUE,
              bslib::card_header(
                bslib::popover(
                  shiny::icon("download"),
                  shiny::numericInput(
                    inputId = "incidence_ggplot2_19_download_width",
                    label = "Width",
                    value = 15
                  ),
                  shiny::numericInput(
                    inputId = "incidence_ggplot2_19_download_height",
                    label = "Height",
                    value = 10
                  ),
                  shinyWidgets::pickerInput(
                    inputId = "incidence_ggplot2_19_download_units",
                    label = "Units",
                    selected = "cm",
                    choices = c("px", "cm", "inch"),
                    multiple = FALSE
                  ),
                  shiny::numericInput(
                    inputId = "incidence_ggplot2_19_download_dpi",
                    label = "dpi",
                    value = 300
                  ),
                  shiny::downloadButton(outputId = "incidence_ggplot2_19_download", label = "Download")
                ),
                class = "text-end"
              ),
              bslib::layout_sidebar(
                sidebar = bslib::sidebar(width = 400, open = "closed",
                  shinyWidgets::pickerInput(
                    inputId = "incidence_ggplot2_19_x",
                    label = "x",
                    selected = "incidence_start_date",
                    multiple = FALSE,
                    choices = c("cdm_name", "denominator_cohort_name", "incidence_start_date", "incidence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level", "estimate_name"),
                    options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                  ),
                  shiny::checkboxInput(
                    inputId = "incidence_ggplot2_19_ribbon",
                    label = "ribbon",
                    value = c(FALSE)
                  ),
                  shinyWidgets::pickerInput(
                    inputId = "incidence_ggplot2_19_facet",
                    label = "facet",
                    selected = NULL,
                    multiple = TRUE,
                    choices = c("cdm_name", "denominator_cohort_name", "incidence_start_date", "incidence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level", "estimate_name"),
                    options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                  ),
                  shinyWidgets::pickerInput(
                    inputId = "incidence_ggplot2_19_colour",
                    label = "colour",
                    selected = NULL,
                    multiple = TRUE,
                    choices = c("cdm_name", "denominator_cohort_name", "incidence_start_date", "incidence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level", "estimate_name"),
                    options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                  ),
                  position = "right"
                ),
                plotly::plotlyOutput("incidence_ggplot2_19")
              )
            )
          )
        )
      )
    ),
    # ,
    # bslib::nav_panel(
    #   title = "Attrition",
    #   icon = shiny::icon("layer-group"),
    #   bslib::layout_sidebar(
    #     sidebar = bslib::sidebar(width = 400, open = "closed",
    #       bslib::accordion(
    #         bslib::accordion_panel(
    #           title = "Information",
    #           icon = shiny::icon("info"),
    #           shiny::p("")
    #         ),
    #         bslib::accordion_panel(
    #           title = "Settings",
    #           shinyWidgets::pickerInput(
    #             inputId = "incidence_attrition_settings_analysis_outcome_washout",
    #             label = "Analysis outcome washout",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "incidence_attrition_settings_analysis_interval",
    #             label = "Analysis interval",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "incidence_attrition_settings_denominator_age_group",
    #             label = "Denominator age group",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "incidence_attrition_settings_denominator_sex",
    #             label = "Denominator sex",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "incidence_attrition_settings_denominator_start_date",
    #             label = "Denominator start date",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "incidence_attrition_settings_denominator_end_date",
    #             label = "Denominator end date",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "incidence_attrition_settings_outcome_cohort_name",
    #             label = "Outcome cohort name",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           )
    #         ),
    #         bslib::accordion_panel(
    #           title = "Settings",
    #           shinyWidgets::pickerInput(
    #             inputId = "incidence_attrition_grouping_cdm_name",
    #             label = "Database",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "incidence_attrition_grouping_denominator_cohort_name",
    #             label = "Denominator cohort name",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "incidence_attrition_grouping_reason",
    #             label = "Reason",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "incidence_attrition_grouping_reason_id",
    #             label = "Reason id",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           )
    #         ),
    #         bslib::accordion_panel(
    #           title = "Variables",
    #           shinyWidgets::pickerInput(
    #             inputId = "incidence_attrition_variable_name",
    #             label = "Variable name",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           )
    #         ),
    #         bslib::accordion_panel(
    #           title = "Estimates",
    #           shinyWidgets::pickerInput(
    #             inputId = "incidence_attrition_estimate_name",
    #             label = "Estimate name",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           )
    #         )
    #       )
    #     ),
    #     bslib::navset_card_tab(
    #       bslib::nav_panel(
    #         title = "Tidy",
    #         bslib::card(
    #           full_screen = TRUE,
    #           bslib::card_header(
    #             bslib::popover(
    #               shiny::icon("download"),
    #               shiny::downloadButton(outputId = "incidence_attrition_tidy_download", label = "Download csv")
    #             ),
    #             class = "text-end"
    #           ),
    #           bslib::layout_sidebar(
    #             sidebar = bslib::sidebar(width = 400, open = "closed",
    #               shinyWidgets::pickerInput(
    #                 inputId = "incidence_attrition_tidy_columns",
    #                 label = "Columns",
    #                 choices = NULL,
    #                 selected = NULL,
    #                 multiple = TRUE,
    #                 options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #               ),
    #               shiny::radioButtons(
    #                 inputId = "incidence_attrition_tidy_pivot",
    #                 label = "Pivot estimates/variables",
    #                 choices = c("none", "estimates", "estimates and variables"),
    #                 selected = "none"
    #               ),
    #               position = "right"
    #             ),
    #             DT::dataTableOutput("incidence_attrition_tidy")
    #           )
    #         )
    #       )
    #       # ,
    #       # bslib::nav_panel(
    #       #   title = "Table incidence attrition",
    #       #   bslib::card(
    #       #     full_screen = TRUE,
    #       #     bslib::card_header(
    #       #       bslib::popover(
    #       #         shiny::icon("download"),
    #       #         shinyWidgets::pickerInput(
    #       #           inputId = "incidence_attrition_gt_22_download_type",
    #       #           label = "File type",
    #       #           selected = "docx",
    #       #           choices = c("docx", "png", "pdf", "html"),
    #       #           multiple = FALSE
    #       #         ),
    #       #         shiny::downloadButton(outputId = "incidence_attrition_gt_22_download", label = "Download")
    #       #       ),
    #       #       class = "text-end"
    #       #     ),
    #       #     bslib::layout_sidebar(
    #       #       sidebar = bslib::sidebar(width = 400, open = "closed",
    #       #         sortable::bucket_list(
    #       #           header = NULL,
    #       #           sortable::add_rank_list(
    #       #             text = "none",
    #       #             labels = c("denominator_cohort_name", "reason", "reason_id", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name"),
    #       #             input_id = "incidence_attrition_gt_22_none"
    #       #           ),
    #       #           sortable::add_rank_list(
    #       #             text = "header",
    #       #             labels = "variable_name",
    #       #             input_id = "incidence_attrition_gt_22_header"
    #       #           ),
    #       #           sortable::add_rank_list(
    #       #             text = "groupColumn",
    #       #             labels = c("cdm_name", "variable_level"),
    #       #             input_id = "incidence_attrition_gt_22_groupColumn"
    #       #           ),
    #       #           sortable::add_rank_list(
    #       #             text = "hide",
    #       #             labels = "estimate_name",
    #       #             input_id = "incidence_attrition_gt_22_hide"
    #       #           )
    #       #         ),
    #       #         position = "right"
    #       #       ),
    #       #       gt::gt_output("incidence_attrition_gt_22") |> withSpinner()
    #       #     )
    #       #   )
    #       # )
    #     )
    #   )
    # )

    ## Prevalence -----
    bslib::nav_panel(
      title = "Prevalence",
      icon = shiny::icon("chart-line"),
      bslib::layout_sidebar(
        sidebar = bslib::sidebar(width = 400, open = "closed",
                                 bslib::accordion(
                                   bslib::accordion_panel(
                                     title = "Settings",
                                     shinyWidgets::pickerInput(
                                       inputId = "prevalence_grouping_cdm_name",
                                       label = "Database",
                                       choices = NULL,
                                       selected = NULL,
                                       multiple = TRUE,
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     ),
                                     shinyWidgets::pickerInput(
                                       inputId = "prevalence_grouping_outcome_cohort_name",
                                       label = "Outcome cohort name",
                                       choices = NULL,
                                       selected = NULL,
                                       multiple = TRUE,
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     ),
                                     shinyWidgets::pickerInput(
                                       inputId = "prevalence_settings_analysis_interval",
                                       label = "Time interval",
                                       choices = NULL,
                                       selected = NULL,
                                       multiple = TRUE,
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     ),
                                     shinyWidgets::pickerInput(
                                       inputId = "prevalence_settings_denominator_age_group",
                                       label = "Denominator age group",
                                       choices = NULL,
                                       selected = NULL,
                                       multiple = TRUE,
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     ),
                                     shinyWidgets::pickerInput(
                                       inputId = "prevalence_settings_denominator_sex",
                                       label = "Denominator sex",
                                       choices = NULL,
                                       selected = NULL,
                                       multiple = TRUE,
                                       options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                     )
                                   )
                                 )
        ),
        bslib::navset_card_tab(
          bslib::nav_panel(
            title = "Table prevalence",
            bslib::card(
              full_screen = TRUE,
              bslib::card_header(
                bslib::popover(
                  shiny::icon("download"),
                  shinyWidgets::pickerInput(
                    inputId = "prevalence_gt_prev1_download_type",
                    label = "File type",
                    selected = "docx",
                    choices = c("docx", "png", "pdf", "html"),
                    multiple = FALSE
                  ),
                  shiny::downloadButton(outputId = "prevalence_gt_prev1_download", label = "Download")
                ),
                class = "text-end"
              ),
              bslib::layout_sidebar(
                sidebar = bslib::sidebar(width = 400, open = "closed",
                                         sortable::bucket_list(
                                           header = NULL,
                                           sortable::add_rank_list(
                                             text = "none",
                                             labels = c("cdm_name", "denominator_cohort_name", "prevalence_start_date", "prevalence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level"),
                                             input_id = "prevalence_gt_prev1_none"
                                           ),
                                           sortable::add_rank_list(
                                             text = "header",
                                             labels = "estimate_name",
                                             input_id = "prevalence_gt_prev1_header"
                                           ),
                                           sortable::add_rank_list(
                                             text = "groupColumn",
                                             labels = character(),
                                             input_id = "prevalence_gt_prev1_groupColumn"
                                           ),
                                           sortable::add_rank_list(
                                             text = "hide",
                                             labels = character(),
                                             input_id = "prevalence_gt_prev1_hide"
                                           )
                                         ),
                                         position = "right"
                ),
                gt::gt_output("prevalence_gt_prev1") |> withSpinner()
              )
            )
          ),
          bslib::nav_panel(
            title = "Plot prevalence",
            bslib::card(
              full_screen = TRUE,
              bslib::card_header(
                bslib::popover(
                  shiny::icon("download"),
                  shiny::numericInput(
                    inputId = "prevalence_ggplot2_prev2_download_width",
                    label = "Width",
                    value = 15
                  ),
                  shiny::numericInput(
                    inputId = "prevalence_ggplot2_prev2_download_height",
                    label = "Height",
                    value = 10
                  ),
                  shinyWidgets::pickerInput(
                    inputId = "prevalence_ggplot2_prev2_download_units",
                    label = "Units",
                    selected = "cm",
                    choices = c("px", "cm", "inch"),
                    multiple = FALSE
                  ),
                  shiny::numericInput(
                    inputId = "prevalence_ggplot2_prev2_download_dpi",
                    label = "dpi",
                    value = 300
                  ),
                  shiny::downloadButton(outputId = "prevalence_ggplot2_prev2_download", label = "Download")
                ),
                class = "text-end"
              ),
              bslib::layout_sidebar(
                sidebar = bslib::sidebar(width = 400, open = "closed",
                                         shinyWidgets::pickerInput(
                                           inputId = "prevalence_ggplot2_prev2_x",
                                           label = "x",
                                           selected = "prevalence_start_date",
                                           multiple = FALSE,
                                           choices = c("cdm_name", "denominator_cohort_name", "prevalence_start_date", "prevalence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level", "estimate_name"),
                                           options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                         ),
                                         shiny::checkboxInput(
                                           inputId = "prevalence_ggplot2_prev2_ribbon",
                                           label = "ribbon",
                                           value = c(FALSE)
                                         ),
                                         shinyWidgets::pickerInput(
                                           inputId = "prevalence_ggplot2_prev2_facet",
                                           label = "facet",
                                           selected = NULL,
                                           multiple = TRUE,
                                           choices = c("cdm_name", "denominator_cohort_name", "prevalence_start_date", "prevalence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level", "estimate_name"),
                                           options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                         ),
                                         shinyWidgets::pickerInput(
                                           inputId = "prevalence_ggplot2_prev2_colour",
                                           label = "colour",
                                           selected = NULL,
                                           multiple = TRUE,
                                           choices = c("cdm_name", "denominator_cohort_name", "prevalence_start_date", "prevalence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level", "estimate_name"),
                                           options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
                                         ),
                                         position = "right"
                ),
                plotly::plotlyOutput("prevalence_ggplot2_prev2")
              )
            )
          )
        )
      )
    ),
    # ,
    # bslib::nav_panel(
    #   title = "Attrition",
    #   icon = shiny::icon("layer-group"),
    #   bslib::layout_sidebar(
    #     sidebar = bslib::sidebar(width = 400, open = "closed",
    #       bslib::accordion(
    #         bslib::accordion_panel(
    #           title = "Information",
    #           icon = shiny::icon("info"),
    #           shiny::p("")
    #         ),
    #         bslib::accordion_panel(
    #           title = "Settings",
    #           shinyWidgets::pickerInput(
    #             inputId = "prevalence_attrition_settings_analysis_outcome_washout",
    #             label = "Analysis outcome washout",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "prevalence_attrition_settings_analysis_interval",
    #             label = "Analysis interval",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "prevalence_attrition_settings_denominator_age_group",
    #             label = "Denominator age group",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "prevalence_attrition_settings_denominator_sex",
    #             label = "Denominator sex",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "prevalence_attrition_settings_denominator_start_date",
    #             label = "Denominator start date",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "prevalence_attrition_settings_denominator_end_date",
    #             label = "Denominator end date",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "prevalence_attrition_settings_outcome_cohort_name",
    #             label = "Outcome cohort name",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           )
    #         ),
    #         bslib::accordion_panel(
    #           title = "Settings",
    #           shinyWidgets::pickerInput(
    #             inputId = "prevalence_attrition_grouping_cdm_name",
    #             label = "Database",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "prevalence_attrition_grouping_denominator_cohort_name",
    #             label = "Denominator cohort name",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "prevalence_attrition_grouping_reason",
    #             label = "Reason",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           ),
    #           shinyWidgets::pickerInput(
    #             inputId = "prevalence_attrition_grouping_reason_id",
    #             label = "Reason id",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           )
    #         ),
    #         bslib::accordion_panel(
    #           title = "Variables",
    #           shinyWidgets::pickerInput(
    #             inputId = "prevalence_attrition_variable_name",
    #             label = "Variable name",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           )
    #         ),
    #         bslib::accordion_panel(
    #           title = "Estimates",
    #           shinyWidgets::pickerInput(
    #             inputId = "prevalence_attrition_estimate_name",
    #             label = "Estimate name",
    #             choices = NULL,
    #             selected = NULL,
    #             multiple = TRUE,
    #             options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #           )
    #         )
    #       )
    #     ),
    #     bslib::navset_card_tab(
    #       bslib::nav_panel(
    #         title = "Tidy",
    #         bslib::card(
    #           full_screen = TRUE,
    #           bslib::card_header(
    #             bslib::popover(
    #               shiny::icon("download"),
    #               shiny::downloadButton(outputId = "prevalence_attrition_tidy_download", label = "Download csv")
    #             ),
    #             class = "text-end"
    #           ),
    #           bslib::layout_sidebar(
    #             sidebar = bslib::sidebar(width = 400, open = "closed",
    #               shinyWidgets::pickerInput(
    #                 inputId = "prevalence_attrition_tidy_columns",
    #                 label = "Columns",
    #                 choices = NULL,
    #                 selected = NULL,
    #                 multiple = TRUE,
    #                 options = list(`actions-box` = TRUE, size = 10, `selected-text-format` = "count > 3")
    #               ),
    #               shiny::radioButtons(
    #                 inputId = "prevalence_attrition_tidy_pivot",
    #                 label = "Pivot estimates/variables",
    #                 choices = c("none", "estimates", "estimates and variables"),
    #                 selected = "none"
    #               ),
    #               position = "right"
    #             ),
    #             DT::dataTableOutput("prevalence_attrition_tidy")
    #           )
    #         )
    #       )
    #       # ,
    #       # bslib::nav_panel(
    #       #   title = "Table prevalence attrition",
    #       #   bslib::card(
    #       #     full_screen = TRUE,
    #       #     bslib::card_header(
    #       #       bslib::popover(
    #       #         shiny::icon("download"),
    #       #         shinyWidgets::pickerInput(
    #       #           inputId = "prevalence_attrition_gt_22_download_type",
    #       #           label = "File type",
    #       #           selected = "docx",
    #       #           choices = c("docx", "png", "pdf", "html"),
    #       #           multiple = FALSE
    #       #         ),
    #       #         shiny::downloadButton(outputId = "prevalence_attrition_gt_22_download", label = "Download")
    #       #       ),
    #       #       class = "text-end"
    #       #     ),
    #       #     bslib::layout_sidebar(
    #       #       sidebar = bslib::sidebar(width = 400, open = "closed",
    #       #         sortable::bucket_list(
    #       #           header = NULL,
    #       #           sortable::add_rank_list(
    #       #             text = "none",
    #       #             labels = c("denominator_cohort_name", "reason", "reason_id", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name"),
    #       #             input_id = "prevalence_attrition_gt_22_none"
    #       #           ),
    #       #           sortable::add_rank_list(
    #       #             text = "header",
    #       #             labels = "variable_name",
    #       #             input_id = "prevalence_attrition_gt_22_header"
    #       #           ),
    #       #           sortable::add_rank_list(
    #       #             text = "groupColumn",
    #       #             labels = c("cdm_name", "variable_level"),
    #       #             input_id = "prevalence_attrition_gt_22_groupColumn"
    #       #           ),
    #       #           sortable::add_rank_list(
    #       #             text = "hide",
    #       #             labels = "estimate_name",
    #       #             input_id = "prevalence_attrition_gt_22_hide"
    #       #           )
    #       #         ),
    #       #         position = "right"
    #       #       ),
    #       #       gt::gt_output("prevalence_attrition_gt_22") |> withSpinner()
    #       #     )
    #       #   )
    #       # )
    #     )
    #   )
    # )


  ),
  # end ------
  bslib::nav_spacer(),
  bslib::nav_item(
    bslib::popover(
      shiny::icon("download"),
      shiny::downloadButton(
        outputId = "download_raw",
        label = "Download raw data",
        icon = shiny::icon("download")
      )
    )
  )
)
