% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyDiagnostics.R
\name{shinyDiagnostics}
\alias{shinyDiagnostics}
\title{Create a shiny app summarising your phenotyping results}
\usage{
shinyDiagnostics(result, directory, open = rlang::is_interactive())
}
\arguments{
\item{result}{A summarised result}

\item{directory}{Directory where to save report}

\item{open}{If TRUE, the shiny app will be launched in a new session. If
FALSE, the shiny app will be created but not launched.}
}
\value{
A shiny app
}
\description{
A shiny app that is designed for any diagnostics results from phenotypeR, this
includes:

* A diagnostics on the database via `databaseDiagnostics`.
* A diagnostics on the cohort_codelist attribute of the cohort via `codelistDiagnostics`.
* A diagnostics on the cohort via `cohortDiagnostics`.
* A diagnostics on the population via `populationDiagnostics`.
* A diagnostics on the matched cohort via `matchedDiagnostics`.
}
\examples{
\donttest{
cdm_local <- omock::mockCdmReference() |>
  omock::mockPerson(nPerson = 100) |>
  omock::mockObservationPeriod() |>
  omock::mockConditionOccurrence() |>
  omock::mockDrugExposure() |>
  omock::mockObservation() |>
  omock::mockMeasurement() |>
  omock::mockVisitOccurrence() |>
  omock::mockProcedureOccurrence() |>
  omock::mockCohort(name = "my_cohort")

  db <- DBI::dbConnect(duckdb::duckdb())
  cdm <- CDMConnector::copyCdmTo(con = db,
                                 cdm = cdm_local,
                                 schema ="main",
                                 overwrite = TRUE)
  my_result_cohort_diag <- cdm$my_cohort |> phenotypeDiagnostics()
  shinyDiagnostics(my_result_cohort_diag, tempdir())
}
}
