\name{writePhySim.tree}
\alias{writePhySim.tree}
\title{Write Tree File in Parenthetic Format}
\usage{
writePhySim.tree(phy, file = "", append = FALSE, format = "Newick",
           multi.line = TRUE, digits = 10)
}
\arguments{
  \item{phy}{an object of class \code{"phylo"} compatible with PhySim or versions of APE predating 1.8-4.}
  \item{file}{a file name specified by either a variable of mode character,
    or a double-quoted string; if \code{file = ""} (the default) then the
    tree is written on the standard output connection (i.e. the console).}
  \item{append}{a logical, if \code{TRUE} the tree is appended to the file
    without erasing the data possibly existing in the file, otherwise
    the file (if it exists) is overwritten (\code{FALSE} the default).}
  \item{format}{a character giving the format of the tree file; by
    default \code{"Newick"}. Currently only \code{"Newick"} is
    available.}
  \item{multi.line}{a logical, if \code{TRUE} (the default) line breaks
    are introduced in the tree in parenthetic form.}
  \item{digits}{a numeric giving the number of digits used for printing
    branch lengths.}
}
\description{
  This function writes in a file a tree in parenthetic format using the
  Newick (also known as New Hampshire) format.
}
\value{
  a vector of mode character if \code{file = ""}, none (invisible
  `NULL') otherwise.
}
\details{
  The node labels and the root edge length, if available, are written in
  the file.
}
\note{
phylogenetic tree information in PhySim is stored in objects of class phylo compatible with old versions of APE (<=1.8-4) but in a format no longer usable by that program. In order to use phylogenetic trees generated by PhySim in APE first write the tree using function writePhySim.tree and then read the tree into a format compatible with APE using the APE function read.tree. 

wirtePhySim.tree and this help file are derived from write.tree and its helpfile obtained from old versions of the package APE (<=1.8-4) by Emmanuel Paradis.
}
\references{
   Felsenstein, J. The Newick tree format.
  \url{http://evolution.genetics.washington.edu/phylip/newicktree.html}

  Olsen, G. Interpretation of the "Newick's 8:45" tree format standard.
  \url{http://evolution.genetics.washington.edu/phylip/newick_doc.html}
}

\author{Emmanuel Paradis}
\seealso{\code{\link{readPhySim.tree}}, to read a phylogenetic tree from a file}
}
\keyword{manip}
\keyword{IO}
