% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_EM.R
\name{params_OU}
\alias{params_OU}
\title{Create an object \code{params_process} for an OU}
\usage{
params_OU(
  p = 1,
  variance = diag(1, p, p),
  selection.strength = diag(1, p, p),
  optimal.value = rep(0, p),
  random = TRUE,
  stationary.root = TRUE,
  value.root = rep(0, p),
  exp.root = rep(0, p),
  var.root = diag(1, p, p),
  edges = NULL,
  values = matrix(0, p, length(edges)),
  relativeTimes = NULL,
  nbr_of_shifts = length(edges),
  phylo = NULL,
  trait_names = NULL,
  ...
)
}
\arguments{
\item{p}{the dimension (number of traits) of the parameters. Default to 1.}

\item{variance}{the variance (rate matrix) of the BM. Default to 
\code{diag(1, p, p)}.}

\item{selection.strength}{the selection strength matrix. Default to 
\code{diag(1, p, p)}.}

\item{optimal.value}{the vector of the optimal values at the root. Default
to \code{rep(0, p)}.}

\item{random}{whether the root of the OU is random (TRUE) or fixed (FALSE).
Default to TRUE.}

\item{stationary.root}{whether the root of the OU is stationary (TRUE) or not.
Default to TRUE.}

\item{value.root}{if random=FALSE, the root value. Default to 0.}

\item{exp.root}{if random=TRUE, the root expectation. Default to 0. If
stationary.root=TRUE, default to \code{optimal.value}.}

\item{var.root}{if random=TRUE, the root variance. Default to
\code{diag(1, p, p)}. If stationary.root=TRUE, default to
the stationary variance computed from \code{variance} and
\code{selection.strength}, see function
\code{\link{compute_stationary_variance}}.}

\item{edges}{a vector of edges where the shifts occur. Default to NULL
(no shift).}

\item{values}{a matrix of shift values, with p lines and as many columns as
the number of shifts. Each column is the p values for one shift. Default to
\code{matrix(0, p, length(edges))}.}

\item{relativeTimes}{(unused) the relative position of the shift on the
branch, between 0 (beginning of the branch) and 1 (end of the branch). Default
to 0.}

\item{nbr_of_shifts}{the number of shifts to use (randomly drawn). Use only
if \code{edges} is not specified. In that case, a phylogenetic tree must be
provided (to allow a random sampling of its edges).}

\item{phylo}{a phylogenetic tree of class \code{\link[ape]{phylo}}. Needed only if
the shifts edges are not specified.}

\item{trait_names}{vector of trait names values. Must be of length p.}

\item{...}{unused.}
}
\value{
an object of class \code{params_process}.
}
\description{
\code{params_OU} creates a coherent object params_process from user 
provided values of the parameters. Non specified parameters are set to 
default values.
}
\seealso{
\code{\link{params_process}}, \code{\link{params_BM}}
}
