% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mobius.R
\name{MobiusMappingCircle}
\alias{MobiusMappingCircle}
\title{Möbius transformation mapping a given circle to a given circle}
\usage{
MobiusMappingCircle(circ1, circ2)
}
\arguments{
\item{circ1, circ2}{\code{Circle} objects}
}
\value{
A Möbius transformation which maps \code{circ1} to \code{circ2}.
}
\description{
Returns a Möbius transformation mapping a given circle to
  another given circle.
}
\examples{
library(PlaneGeometry)
C1 <- Circle$new(c(0, 0), 1)
C2 <- Circle$new(c(1, 2), 3)
M <- MobiusMappingCircle(C1, C2)
C3 <- M$transformCircle(C1)
C3$isEqual(C2)
}
