% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlasmodeBin.R
\name{PlasmodeBin}
\alias{PlasmodeBin}
\title{Performs the plasmode simulation}
\usage{
PlasmodeBin(formulaOut = NULL, objectOut = NULL, formulaExp = NULL,
  objectExp = NULL, data, idVar, effectOR = 1, MMOut = 1, MMExp = 1,
  nsim, size, eventRate = NULL, exposedPrev = NULL)
}
\arguments{
\item{formulaOut}{An outcome model formula containing the binary outcome on the left-hand side and binary exposure along with potential confounders on the right-hand side.The functional form of the outcome model should be, Outcome ~ Exposure + Confounders. (Exposure main effect must be first independent variable)}

\item{objectOut}{A fitted model for the outcome model. The functional form of the fitted model for the outcome variable should be of form, Outcome ~ Exposure + Confounders.}

\item{formulaExp}{An exposure model formula containing the binary exposure on the left-hand side and potential confounders on the right-hand side. The functional form of the exposure model is, Exposure ~ Confounders.}

\item{objectExp}{A fitted model object for the exposure model.}

\item{data}{The dataset on which simulations are based. The data is required only when formulaOut or formulaExp or both are supplied to the argument.}

\item{idVar}{Name of the ID variable.}

\item{effectOR}{The desired treatment effect odds ratio. By default effectOR = 1.}

\item{MMOut}{A multiplier of confounder effects on outcome applied to the estimated log ORs in the outcome model. By default MMOut = 1 but one can specify a vector of length equivalent to the number of variables on the right-hand side of the outcome model.}

\item{MMExp}{A multiplier of confounder effects on exposure applied to the estimated log ORs in the exposure model. By default MMExp = 1 but one can specify a vector of length equivalent to the number of variables on the right-hand side of the exposure model.}

\item{nsim}{Number of desired simulated datasets.}

\item{size}{Desired size of simulated datasets (i.e., # of individuals).}

\item{eventRate}{Desired average event rate. Default is the event rate in the observed data.}

\item{exposedPrev}{Desired average exposure rate. Default is the esposure prevalence in the observed data.}
}
\value{
PlasmodeBin returns true beta coefficients used to generate the outcome and the exposure. It also returns the relative risk and risk difference estimated by the plasmode simulated data along with the data frame with the simulated data, including sampled IDs for each of nsim datasets along with simulated outcomes, exposure, or both.
\item{TrueOutBeta}{True beta coefficients used to generate the outcome.}
\item{TrueExpBeta}{True beta coefficients used to generate the exposure.}
\item{RR}{True relative risk estimated using the plasmode simulated data.}
\item{RD}{True risk difference estimated using the plasmode simulated data.}
\item{Sim_Data}{Plasmode simulated data, including sampled IDs for each of nsim datasets along with simulated outcomes, exposure, or both.}
}
\description{
Creates 'plasmode'simulated datasets based on a given dataset when the outcome variable and exposure variable are binary. Plasmode simulation samples subjects with replacement from the observed data, uses subjects’ covariate data as is, and simulates exposure, outcome, or both.
}
\details{
At least one of formulaOut, formulaExp, objectOut, and objectExp must be specified, and which of these are specified will determine what gets simulated and how. If objectOut or objectExp are specified, these objects are used as the base model for outcome and exposure simulation. If formulaOut or formulaExp are specified, then data should be given and base models are fit in the data using glm2 with the given formulas. If formulaOut or objectOut is specified, outcome will be simulated based on subjects’ observed exposure. If formulaExp or objectExp is specified, exposure will be simulated. And if models are specified for both outcome and exposure, both variables will be simulated with simulated outcome dependent on the simulated exposure.
}
\examples{
{
library(mgcv)
library(nlme)
library(glm2)
library(arm)
library(MASS)
library(lme4)
library(epiDisplay)
library(foreign)
library(nnet)

data("Compaq")
levels(Compaq$stage) <- c(1,2,3,4)
Compaq$stage<-as.numeric(levels(Compaq$stage))[Compaq$stage]
## Creating the binary exposure variable
Compaq$exposure<-ifelse(Compaq$hospital == "Public hospital",1,0)
## Creating binary variables for some confounders
Compaq$ses1<-ifelse(Compaq$ses == "Poor",1,0)
Compaq$ses2<-ifelse(Compaq$ses == "Poor-middle",1,0)
Compaq$ses3<-ifelse(Compaq$ses == "High-middle",1,0)

Compaq$age1<-ifelse(Compaq$agegr == "<40",1,0)
Compaq$age2<-ifelse(Compaq$agegr == "40-49",1,0)
Compaq$age3<-ifelse(Compaq$agegr == "50-59",1,0)


## Creating the formulas for the outcome and the exposure model
form1<- status~ exposure + stage + ses1 + ses2 + ses3 + age1 + age2 + age3
form2<- exposure ~ stage + ses1 + ses2 + ses3 + age1 + age2 + age3

set.seed(111)
Bin_Form1<-PlasmodeBin(formulaOut=form1, objectOut=NULL,formulaExp=form2,
                     objectExp= NULL,data=Compaq,idVar="id",effectOR =1,
                     MMOut=c(1,1,2,1,1,2,1,2),MMExp=c(1,1,1,1,1,1,1),
                     nsim=2, size=nrow(Compaq), eventRate=NULL, exposedPrev=NULL)

Bin_Form2<-PlasmodeBin(formulaOut=form1, objectOut=NULL,formulaExp=NULL,
                      objectExp= NULL,data=Compaq,idVar="id",effectOR =1,
                      MMOut=c(1,1,2,1,1,2,1,2),MMExp=1, nsim=2,
                      size=nrow(Compaq), eventRate=NULL, exposedPrev=NULL)

Bin_Form3<-PlasmodeBin(formulaOut=NULL, objectOut=NULL,formulaExp=form2,
                      objectExp= NULL,data=Compaq,idVar="id",effectOR =1,
                      MMOut=1,MMExp=c(1,1,1,1,1,1,1), nsim=2,
                      size=nrow(Compaq), eventRate=NULL, exposedPrev=NULL)


###################################################################################################
## One can provide the fitted model for the outcome model and the exposure model estimated by
## glm, gam, and bayesglm. The functional form of the fitted model for the outcome variable should
## of the form Outcome ~ Exposure + Confounders. The functional form of the exposure model is,
## Exposure ~ Confounders.
####################################################################################################

Coeff1<- bayesglm(form1, family = "binomial", data=Compaq,control=glm.control(trace=TRUE))
Coeff2<- bayesglm(form2, family = "binomial", data=Compaq,control=glm.control(trace=TRUE))
sizesim<-nrow(model.matrix(Coeff1))
sizesim1<-nrow(model.matrix(Coeff2))

Bin_Obj1<-PlasmodeBin(formulaOut=NULL, objectOut=Coeff1,formulaExp=NULL,
                     objectExp = Coeff2, idVar=Compaq$id,effectOR =1,
                     MMOut=c(1.5,1,2,1,1,1,1,1),MMExp=c(1,1,1,1,1,1,1),
                     nsim=2, size=sizesim, eventRate=NULL, exposedPrev=NULL)

Bin_Obj2<-PlasmodeBin(formulaOut=NULL, objectOut=Coeff1,formulaExp=NULL,
                     objectExp = NULL,idVar=Compaq$id,effectOR =1,
                     MMOut=c(1.5,1,2,1,1,1,1,1),MMExp=1,
                     nsim=2, size=sizesim, eventRate=NULL, exposedPrev=NULL)

Bin_Obj3<-PlasmodeBin(formulaOut=NULL, objectOut=NULL,formulaExp=NULL,
                     objectExp = Coeff2,idVar=Compaq$id,effectOR =1, MMOut=1,
                     MMExp=c(1,1,1,1,1,1,1),
                     nsim=2, size=sizesim1, eventRate=NULL, exposedPrev=NULL)
}
}
\author{
Jessica M. Franklin, Younathan Abdia, and Shirley Wang
}
