% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor.mat.R
\name{cor.mat}
\alias{cor.mat}
\title{Calculate the correlation matrix of the z-statistics for in a two-period
multi-arm platform design with delayed arms}
\usage{
cor.mat(K, M = 0, n, n0, n0t = NULL)
}
\arguments{
\item{K}{the number of experimental arms in the  first period in a two-period K+M trial}

\item{M}{the number of delayed additional experimental arms added in the second period,
default = 0 for calculating the correlation matrix of the Z-test statistics for a
K-experimental arm trial in the first period}

\item{n}{a positive integer, which is the sample size in each of the experimental arms}

\item{n0}{a positive integer, which is the sample size of the control for each of the
experimental arms}

\item{n0t}{the number of patients already enrolled in the control arm when delayed
experimental arms are added, default to NULL for calculating correlation matrix of
the k-experimental arm trial in the first period}
}
\value{
\emph{cormat}, the correlation matrix of Z-test statistics in the
two-period K+M experimental arm trial with one common control arm, or that in the
k-experimental arm trial in the first period when M = 0
}
\description{
Calculate the correlation matrix of the z-statistics in the two-period multi-arm platform
design with delayed arms, given K, M, n, n0 and n0t.
}
\details{
Given K, M, n, n0 and n0t, calculate the correlation matrix of the z-statistics in the
two-period K+M experimental arm trial with one common control arm.
}
\examples{
cor.mat(K = 2, M = 0, n = 101, n0 = 143)

#$cormat
#        [,1]      [,2]
#[1,] 1.0000000 0.4139344
#[2,] 0.4139344 1.0000000

#$cor1
#[1] 0.4139344

#$cor2
#NULL

 cor.mat(K = 2, M = 2, n = 107, n0 = 198, n0t = 43)

#$cormat
#      [,1]      [,2]      [,3]      [,4]
#[1,] 1.0000000 0.3508197 0.2746316 0.2746316
#[2,] 0.3508197 1.0000000 0.2746316 0.2746316
#[3,] 0.2746316 0.2746316 1.0000000 0.3508197
#[4,] 0.2746316 0.2746316 0.3508197 1.0000000

#$cor1
#[1] 0.3508197

#$cor2
#[1] 0.2746316

}
