% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_stage_multiarm.R
\name{one_stage_multiarm}
\alias{one_stage_multiarm}
\title{Calculate the sample size and other design parameters for an one-stage K-arm trial using the root-K
rule for the allocation ratio}
\usage{
one_stage_multiarm(K, fwer, marginal.power, delta, seed = 123)
}
\arguments{
\item{K}{the number of experimental arms}

\item{fwer}{the family-wise type I error rate}

\item{marginal.power}{the marginal power for each experimental-control comparison}

\item{delta}{the standardized clinical effect size expected to be detected
in the trial}

\item{seed}{an integer for random number generation for numerically evaluating integration, default = 123}
}
\value{
\emph{n1} the sample size of each of the K experimental arms

\emph{n0_1} the sample size of the control arm

\emph{N1} the total sample size of a K-arm trial

\emph{z_alpha1} the critical value for the comparison between any of the K-experimental arm
in the first period and its corresponding control

\emph{z_beta1} the value of the quantile function of the standard normal distribution with
probability = marginal power of the K-arm trial

\emph{Power1} the disjunctive power of the K-arm trial defined as the
probability of rejecting at least one of the K experimental arms under the
alternative hypothesis

\emph{corMat1} the correlation matrix of the Z-test statistics
}
\description{
This design is to find the required sample sizes and the associated critical value to control the overall
type I error rate (FWER) and achieve the user-specified marginal (i.e., experimental-wise or pairwise)
power. Calculate required sample sizes for each of the experimental arm (n1), the control arm (n0_1),
the total sample size (N1) and the critical value z_alpha1 in a K-arm trial setting (K experimental arms
and 1 common control arm).
}
\details{
Given the number of experimental arm (K), the family-wise type I error rate, the
marginal power for each experimental-control comparison and the standardized effect
size to calculate the sample size and other design parameters for the K-experimental
arm trial with one control arm.
}
\examples{
one_stage_multiarm(K = 2, fwer = 0.025, marginal.power = 0.8, delta = 0.4)
#$n1
#[1] 101

#$n0_1
#[1] 143

#$N1
#[1] 345

#$z_alpha1
#[1] 2.220604

#$z_beta1
#[1] 0.8416212

#$Power1
#[1] 0.9222971

#$corMat1
#[,1]      [,2]
#[1,] 1.0000000 0.4142136
#[2,] 0.4142136 1.0000000

}
\references{
\verb{    }Pan, H., Yuan, X. and Ye, J. (2022). An optimal two-period multi-arm confirmatory platform design
with adding new arms. Manuscript submitted for publication.

\verb{    }Dunnett, C. W. (1955). A multiple comparison procedure for comparing
several treatments with a control. Journal of the American Statistical
Association, 50(272), 1096-1121.
}
\author{
\verb{    }Xiaomeng Yuan, Haitao Pan
}
