% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_network.R
\name{VDJ_network}
\alias{VDJ_network}
\title{Creates a similarity network where clones with similar CDR3s are connected.}
\usage{
VDJ_network(
  VDJ,
  distance.cutoff,
  per.sample,
  platypus.version,
  known.binders,
  hcdr3.only
)
}
\arguments{
\item{VDJ}{Either (for platypus version "v2") output from VDJ_analyze function. This should be a list of clonotype dataframes, with each list element corresponding to a single VDJ repertoire, OR (for platypus version "v3") the the VDJ matrix output of the VDJ_GEX_matrix() function (VDJ.GEX.matrix.output[[1]])}

\item{distance.cutoff}{The threshold Levenshtein distance for which two nodes will be connected on the similarity network.}

\item{per.sample}{logical value indicating if a single networks should be produced for each mouse.}

\item{platypus.version}{Character. Defaults to "v3". Can be "v2" or "v3" dependent on the input format}

\item{known.binders}{Either a character vector with cdr3s of known binders or a data frame with cdr3s in the first and the corresponding specificity in the second column. If this parameter is defined, the output will be a network with only edges between known binders and the repertoire nodes and edges between the known binders that have at least one edge to a repertoire node}

\item{hcdr3.only}{logical value indicating if the network is based on heavy chain cdr3s (hcdr3.only = T) or pasted heavy and light chain cdr3s (hcdr3.only = F), works for platypus.version 3 only}
}
\value{
returns a list containing networks and network information. If per.sample is set to TRUE then the result will be a network for each repertoire. If per.sample ==F, output[[1]] <- will contain the network, output[[2]] will contain the dataframe with information on each node, such as frequency, mouse origin etc. output[[3]] will contain the connected index - these numbers indicate that the nodes are connected to at least one other node. output[[4]] contains the paired graph - so the graph where only the connected nodes are drawn.
}
\description{
Creates a similarity network where clones with similar CDR3s are connected.
}
\examples{
#Platypus v2
#network_out <- VDJ_network(VDJ = VDJ_analyze.out[[1]],per.sample = TRUE,distance.cutoff = 2)
#Platypus v3
network_out <- VDJ_network(VDJ = Platypus::small_vgm[[1]],per.sample = FALSE,distance.cutoff = 2)

}
