% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_clonal_expansion_abundances.R
\name{VDJ_clonal_expansion_abundances}
\alias{VDJ_clonal_expansion_abundances}
\title{Wrapper function for VDJ_abundances to obtain ranked clonotype barplots}
\usage{
VDJ_clonal_expansion_abundances(
  VDJ,
  features,
  count.level,
  max.clonotypes,
  rank.clonotypes,
  specific.feat.colors
)
}
\arguments{
\item{VDJ}{VDJ or VDJ.GEX.matrix[[1]] object, as obtained from the VDJ_GEX_matrix function in Platypus.}

\item{features}{string or vector of strings, denoting the columns of the VDJ/VDJ.GEX.matrix[[1]] object from which to extract the unique feature values.}

\item{count.level}{string, 'absolute' will return the absolute counts, 'group.level.proportions' will return the counts divided by the total number or elements/values in the specific groups (group level proportions), 'sample.level.proportions' will return the counts divided by the total number of elements in the sample.}

\item{max.clonotypes}{integer or NULL, the maximum number of clonotypes for which to count features. If NULL, it will count for all clonotypes.}

\item{rank.clonotypes}{boolean, if T - clonotypes will be ranked and order according to their expansion.}

\item{specific.feat.colors}{named list (or NULL) of specific colors to be used in the final barplots.}
}
\value{
Either a count dataframe with the following columns: group(=unique group value, e.g., 'clonotype1' if grouping.column='clonotype_id'), sample, group_frequency, unique_feature_values, feature_value_counts, total_feature_names
or a barplot of the counts/proportions per feature, per group.
}
\description{
Wraps the VDJ_abundances function and output a barplot of clonotypes ranked by expansion (x axis) with counts of the specific feature values per clonotype (y axis). For a more in-depth configuration of the barplots (e.g., including clonotypes with missing features, different strategies for NA values, etc.), use the VDJ_abundances function with output.format='plots'.
}
\examples{
\dontrun{
VDJ_clonal_expansion_abundances(VDJ = small_vgm[[1]],
features='VDJ_cgene',count.level='absolute',
max.clonotypes=30, rank.clonotypes=T, specific.feat.colors=NULL)
}
}
